package zio.aws.cloudcontrol.model
import zio.aws.cloudcontrol.model.primitives.{
  Identifier,
  Timestamp,
  RequestToken,
  TypeName,
  StatusMessage,
  Properties
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ProgressEvent(
    typeName: Option[TypeName] = None,
    identifier: Option[Identifier] = None,
    requestToken: Option[RequestToken] = None,
    operation: Option[zio.aws.cloudcontrol.model.Operation] = None,
    operationStatus: Option[zio.aws.cloudcontrol.model.OperationStatus] = None,
    eventTime: Option[Timestamp] = None,
    resourceModel: Option[Properties] = None,
    statusMessage: Option[StatusMessage] = None,
    errorCode: Option[zio.aws.cloudcontrol.model.HandlerErrorCode] = None,
    retryAfter: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent = {
    import ProgressEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent
      .builder()
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        identifier.map(value => Identifier.unwrap(value): java.lang.String)
      )(_.identifier)
      .optionallyWith(
        requestToken.map(value => RequestToken.unwrap(value): java.lang.String)
      )(_.requestToken)
      .optionallyWith(operation.map(value => value.unwrap))(_.operation)
      .optionallyWith(operationStatus.map(value => value.unwrap))(
        _.operationStatus
      )
      .optionallyWith(eventTime.map(value => Timestamp.unwrap(value): Instant))(
        _.eventTime
      )
      .optionallyWith(
        resourceModel.map(value => Properties.unwrap(value): java.lang.String)
      )(_.resourceModel)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        retryAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.retryAfter)
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly =
    zio.aws.cloudcontrol.model.ProgressEvent.wrap(buildAwsValue())
}
object ProgressEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.ProgressEvent =
      zio.aws.cloudcontrol.model.ProgressEvent(
        typeName.map(value => value),
        identifier.map(value => value),
        requestToken.map(value => value),
        operation.map(value => value),
        operationStatus.map(value => value),
        eventTime.map(value => value),
        resourceModel.map(value => value),
        statusMessage.map(value => value),
        errorCode.map(value => value),
        retryAfter.map(value => value)
      )
    def typeName: Option[TypeName]
    def identifier: Option[Identifier]
    def requestToken: Option[RequestToken]
    def operation: Option[zio.aws.cloudcontrol.model.Operation]
    def operationStatus: Option[zio.aws.cloudcontrol.model.OperationStatus]
    def eventTime: Option[Timestamp]
    def resourceModel: Option[Properties]
    def statusMessage: Option[StatusMessage]
    def errorCode: Option[zio.aws.cloudcontrol.model.HandlerErrorCode]
    def retryAfter: Option[Timestamp]
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getIdentifier: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getRequestToken: ZIO[Any, AwsError, RequestToken] =
      AwsError.unwrapOptionField("requestToken", requestToken)
    def getOperation: ZIO[Any, AwsError, zio.aws.cloudcontrol.model.Operation] =
      AwsError.unwrapOptionField("operation", operation)
    def getOperationStatus
        : ZIO[Any, AwsError, zio.aws.cloudcontrol.model.OperationStatus] =
      AwsError.unwrapOptionField("operationStatus", operationStatus)
    def getEventTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventTime", eventTime)
    def getResourceModel: ZIO[Any, AwsError, Properties] =
      AwsError.unwrapOptionField("resourceModel", resourceModel)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.cloudcontrol.model.HandlerErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getRetryAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("retryAfter", retryAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent
  ) extends zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly {
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudcontrol.model.primitives.TypeName(value))
    override val identifier: Option[Identifier] = scala
      .Option(impl.identifier())
      .map(value => zio.aws.cloudcontrol.model.primitives.Identifier(value))
    override val requestToken: Option[RequestToken] = scala
      .Option(impl.requestToken())
      .map(value => zio.aws.cloudcontrol.model.primitives.RequestToken(value))
    override val operation: Option[zio.aws.cloudcontrol.model.Operation] = scala
      .Option(impl.operation())
      .map(value => zio.aws.cloudcontrol.model.Operation.wrap(value))
    override val operationStatus
        : Option[zio.aws.cloudcontrol.model.OperationStatus] = scala
      .Option(impl.operationStatus())
      .map(value => zio.aws.cloudcontrol.model.OperationStatus.wrap(value))
    override val eventTime: Option[Timestamp] = scala
      .Option(impl.eventTime())
      .map(value => zio.aws.cloudcontrol.model.primitives.Timestamp(value))
    override val resourceModel: Option[Properties] = scala
      .Option(impl.resourceModel())
      .map(value => zio.aws.cloudcontrol.model.primitives.Properties(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.cloudcontrol.model.primitives.StatusMessage(value))
    override val errorCode
        : Option[zio.aws.cloudcontrol.model.HandlerErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.cloudcontrol.model.HandlerErrorCode.wrap(value))
    override val retryAfter: Option[Timestamp] = scala
      .Option(impl.retryAfter())
      .map(value => zio.aws.cloudcontrol.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent
  ): zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly = new Wrapper(impl)
}
