package zio.aws.cloudcontrol
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.cloudcontrol.model.{
  DeleteResourceResponse,
  UpdateResourceResponse,
  GetResourceResponse,
  ResourceDescription,
  CancelResourceRequestRequest,
  ListResourcesResponse,
  ProgressEvent,
  ListResourceRequestsResponse,
  GetResourceRequestStatusRequest,
  DeleteResourceRequest,
  GetResourceRequestStatusResponse,
  ListResourcesRequest,
  CancelResourceRequestResponse,
  CreateResourceResponse,
  GetResourceRequest,
  CreateResourceRequest,
  ListResourceRequestsRequest,
  UpdateResourceRequest
}
import zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.cloudcontrol.{
  CloudControlAsyncClientBuilder,
  CloudControlAsyncClient
}
import scala.jdk.CollectionConverters.*
trait CloudControl extends AspectSupport[CloudControl] {
  val api: CloudControlAsyncClient
  def getResource(
      request: zio.aws.cloudcontrol.model.GetResourceRequest
  ): IO[AwsError, zio.aws.cloudcontrol.model.GetResourceResponse.ReadOnly]
  def cancelResourceRequest(
      request: zio.aws.cloudcontrol.model.CancelResourceRequestRequest
  ): IO[
    AwsError,
    zio.aws.cloudcontrol.model.CancelResourceRequestResponse.ReadOnly
  ]
  def createResource(
      request: zio.aws.cloudcontrol.model.CreateResourceRequest
  ): IO[AwsError, zio.aws.cloudcontrol.model.CreateResourceResponse.ReadOnly]
  def updateResource(
      request: zio.aws.cloudcontrol.model.UpdateResourceRequest
  ): IO[AwsError, zio.aws.cloudcontrol.model.UpdateResourceResponse.ReadOnly]
  def getResourceRequestStatus(
      request: zio.aws.cloudcontrol.model.GetResourceRequestStatusRequest
  ): IO[
    AwsError,
    zio.aws.cloudcontrol.model.GetResourceRequestStatusResponse.ReadOnly
  ]
  def listResourceRequests(
      request: zio.aws.cloudcontrol.model.ListResourceRequestsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listResourceRequestsPaginated(
      request: zio.aws.cloudcontrol.model.ListResourceRequestsRequest
  ): IO[
    AwsError,
    zio.aws.cloudcontrol.model.ListResourceRequestsResponse.ReadOnly
  ]
  def listResources(
      request: zio.aws.cloudcontrol.model.ListResourcesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cloudcontrol.model.ListResourcesResponse.ReadOnly,
    zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly
  ]]
  def listResourcesPaginated(
      request: zio.aws.cloudcontrol.model.ListResourcesRequest
  ): IO[AwsError, zio.aws.cloudcontrol.model.ListResourcesResponse.ReadOnly]
  def deleteResource(
      request: zio.aws.cloudcontrol.model.DeleteResourceRequest
  ): IO[AwsError, zio.aws.cloudcontrol.model.DeleteResourceResponse.ReadOnly]
}
object CloudControl {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CloudControl] = customized(
    identity
  )
  def customized(
      customization: CloudControlAsyncClientBuilder => CloudControlAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CloudControl] = managed(
    customization
  ).toLayer
  def managed(
      customization: CloudControlAsyncClientBuilder => CloudControlAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CloudControl] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = CloudControlAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CloudControlAsyncClient, CloudControlAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        CloudControlAsyncClient,
        CloudControlAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new CloudControlImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class CloudControlImpl[R](
      override val api: CloudControlAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CloudControl
      with AwsServiceBase[R] {
    override val serviceName: String = "CloudControl"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CloudControlImpl[R1] = new CloudControlImpl(api, newAspect, r)
    def getResource(
        request: zio.aws.cloudcontrol.model.GetResourceRequest
    ): IO[AwsError, zio.aws.cloudcontrol.model.GetResourceResponse.ReadOnly] =
      asyncRequestResponse[GetResourceRequest, GetResourceResponse](
        "getResource",
        api.getResource
      )(request.buildAwsValue())
        .map(zio.aws.cloudcontrol.model.GetResourceResponse.wrap)
        .provideEnvironment(r)
    def cancelResourceRequest(
        request: zio.aws.cloudcontrol.model.CancelResourceRequestRequest
    ): IO[
      AwsError,
      zio.aws.cloudcontrol.model.CancelResourceRequestResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelResourceRequestRequest,
      CancelResourceRequestResponse
    ]("cancelResourceRequest", api.cancelResourceRequest)(
      request.buildAwsValue()
    ).map(zio.aws.cloudcontrol.model.CancelResourceRequestResponse.wrap)
      .provideEnvironment(r)
    def createResource(
        request: zio.aws.cloudcontrol.model.CreateResourceRequest
    ): IO[
      AwsError,
      zio.aws.cloudcontrol.model.CreateResourceResponse.ReadOnly
    ] = asyncRequestResponse[CreateResourceRequest, CreateResourceResponse](
      "createResource",
      api.createResource
    )(request.buildAwsValue())
      .map(zio.aws.cloudcontrol.model.CreateResourceResponse.wrap)
      .provideEnvironment(r)
    def updateResource(
        request: zio.aws.cloudcontrol.model.UpdateResourceRequest
    ): IO[
      AwsError,
      zio.aws.cloudcontrol.model.UpdateResourceResponse.ReadOnly
    ] = asyncRequestResponse[UpdateResourceRequest, UpdateResourceResponse](
      "updateResource",
      api.updateResource
    )(request.buildAwsValue())
      .map(zio.aws.cloudcontrol.model.UpdateResourceResponse.wrap)
      .provideEnvironment(r)
    def getResourceRequestStatus(
        request: zio.aws.cloudcontrol.model.GetResourceRequestStatusRequest
    ): IO[
      AwsError,
      zio.aws.cloudcontrol.model.GetResourceRequestStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      GetResourceRequestStatusRequest,
      GetResourceRequestStatusResponse
    ]("getResourceRequestStatus", api.getResourceRequestStatus)(
      request.buildAwsValue()
    ).map(zio.aws.cloudcontrol.model.GetResourceRequestStatusResponse.wrap)
      .provideEnvironment(r)
    def listResourceRequests(
        request: zio.aws.cloudcontrol.model.ListResourceRequestsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      ListResourceRequestsRequest,
      ListResourceRequestsResponse,
      ProgressEvent
    ](
      "listResourceRequests",
      api.listResourceRequests,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resourceRequestStatusSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudcontrol.model.ProgressEvent.wrap(item))
      .provideEnvironment(r)
    def listResourceRequestsPaginated(
        request: zio.aws.cloudcontrol.model.ListResourceRequestsRequest
    ): IO[
      AwsError,
      zio.aws.cloudcontrol.model.ListResourceRequestsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListResourceRequestsRequest,
      ListResourceRequestsResponse
    ]("listResourceRequests", api.listResourceRequests)(request.buildAwsValue())
      .map(zio.aws.cloudcontrol.model.ListResourceRequestsResponse.wrap)
      .provideEnvironment(r)
    def listResources(
        request: zio.aws.cloudcontrol.model.ListResourcesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.cloudcontrol.model.ListResourcesResponse.ReadOnly,
      zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly
    ]] = asyncPaginatedRequest[
      ListResourcesRequest,
      ListResourcesResponse,
      ResourceDescription
    ](
      "listResources",
      api.listResources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resourceDescriptions().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.cloudcontrol.model.ListResourcesResponse.wrap)
          .mapOutput(
            _.map(item =>
              zio.aws.cloudcontrol.model.ResourceDescription.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listResourcesPaginated(
        request: zio.aws.cloudcontrol.model.ListResourcesRequest
    ): IO[AwsError, zio.aws.cloudcontrol.model.ListResourcesResponse.ReadOnly] =
      asyncRequestResponse[ListResourcesRequest, ListResourcesResponse](
        "listResources",
        api.listResources
      )(request.buildAwsValue())
        .map(zio.aws.cloudcontrol.model.ListResourcesResponse.wrap)
        .provideEnvironment(r)
    def deleteResource(
        request: zio.aws.cloudcontrol.model.DeleteResourceRequest
    ): IO[
      AwsError,
      zio.aws.cloudcontrol.model.DeleteResourceResponse.ReadOnly
    ] = asyncRequestResponse[DeleteResourceRequest, DeleteResourceResponse](
      "deleteResource",
      api.deleteResource
    )(request.buildAwsValue())
      .map(zio.aws.cloudcontrol.model.DeleteResourceResponse.wrap)
      .provideEnvironment(r)
  }
  def getResource(request: zio.aws.cloudcontrol.model.GetResourceRequest): ZIO[
    zio.aws.cloudcontrol.CloudControl,
    AwsError,
    zio.aws.cloudcontrol.model.GetResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResource(request))
  def cancelResourceRequest(
      request: zio.aws.cloudcontrol.model.CancelResourceRequestRequest
  ): ZIO[
    zio.aws.cloudcontrol.CloudControl,
    AwsError,
    zio.aws.cloudcontrol.model.CancelResourceRequestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelResourceRequest(request))
  def createResource(
      request: zio.aws.cloudcontrol.model.CreateResourceRequest
  ): ZIO[
    zio.aws.cloudcontrol.CloudControl,
    AwsError,
    zio.aws.cloudcontrol.model.CreateResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createResource(request))
  def updateResource(
      request: zio.aws.cloudcontrol.model.UpdateResourceRequest
  ): ZIO[
    zio.aws.cloudcontrol.CloudControl,
    AwsError,
    zio.aws.cloudcontrol.model.UpdateResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResource(request))
  def getResourceRequestStatus(
      request: zio.aws.cloudcontrol.model.GetResourceRequestStatusRequest
  ): ZIO[
    zio.aws.cloudcontrol.CloudControl,
    AwsError,
    zio.aws.cloudcontrol.model.GetResourceRequestStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourceRequestStatus(request))
  def listResourceRequests(
      request: zio.aws.cloudcontrol.model.ListResourceRequestsRequest
  ): ZStream[zio.aws.cloudcontrol.CloudControl, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listResourceRequests(request))
  def listResourceRequestsPaginated(
      request: zio.aws.cloudcontrol.model.ListResourceRequestsRequest
  ): ZIO[
    zio.aws.cloudcontrol.CloudControl,
    AwsError,
    zio.aws.cloudcontrol.model.ListResourceRequestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResourceRequestsPaginated(request))
  def listResources(
      request: zio.aws.cloudcontrol.model.ListResourcesRequest
  ): ZIO[zio.aws.cloudcontrol.CloudControl, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cloudcontrol.model.ListResourcesResponse.ReadOnly,
    zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listResources(request))
  def listResourcesPaginated(
      request: zio.aws.cloudcontrol.model.ListResourcesRequest
  ): ZIO[
    zio.aws.cloudcontrol.CloudControl,
    AwsError,
    zio.aws.cloudcontrol.model.ListResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResourcesPaginated(request))
  def deleteResource(
      request: zio.aws.cloudcontrol.model.DeleteResourceRequest
  ): ZIO[
    zio.aws.cloudcontrol.CloudControl,
    AwsError,
    zio.aws.cloudcontrol.model.DeleteResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResource(request))
}
