package zio.aws.cloudcontrol.model
import zio.aws.cloudcontrol.model.primitives.{Properties, Identifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceDescription(
    identifier: Option[Identifier] = None,
    properties: Option[Properties] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription = {
    import ResourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription
      .builder()
      .optionallyWith(
        identifier.map(value => Identifier.unwrap(value): java.lang.String)
      )(_.identifier)
      .optionallyWith(
        properties.map(value => Properties.unwrap(value): java.lang.String)
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly =
    zio.aws.cloudcontrol.model.ResourceDescription.wrap(buildAwsValue())
}
object ResourceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.ResourceDescription =
      zio.aws.cloudcontrol.model.ResourceDescription(
        identifier.map(value => value),
        properties.map(value => value)
      )
    def identifier: Option[Identifier]
    def properties: Option[Properties]
    def getIdentifier: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getProperties: ZIO[Any, AwsError, Properties] =
      AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription
  ) extends zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly {
    override val identifier: Option[Identifier] = scala
      .Option(impl.identifier())
      .map(value => zio.aws.cloudcontrol.model.primitives.Identifier(value))
    override val properties: Option[Properties] = scala
      .Option(impl.properties())
      .map(value => zio.aws.cloudcontrol.model.primitives.Properties(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription
  ): zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly = new Wrapper(impl)
}
