package zio.aws.cloudcontrol.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateResourceResponse(
    progressEvent: Option[zio.aws.cloudcontrol.model.ProgressEvent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.CreateResourceResponse = {
    import CreateResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.CreateResourceResponse
      .builder()
      .optionallyWith(progressEvent.map(value => value.buildAwsValue()))(
        _.progressEvent
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.CreateResourceResponse.ReadOnly =
    zio.aws.cloudcontrol.model.CreateResourceResponse.wrap(buildAwsValue())
}
object CreateResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.CreateResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.CreateResourceResponse =
      zio.aws.cloudcontrol.model
        .CreateResourceResponse(progressEvent.map(value => value.asEditable))
    def progressEvent: Option[zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly]
    def getProgressEvent: ZIO[
      Any,
      AwsError,
      zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly
    ] = AwsError.unwrapOptionField("progressEvent", progressEvent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.CreateResourceResponse
  ) extends zio.aws.cloudcontrol.model.CreateResourceResponse.ReadOnly {
    override val progressEvent
        : Option[zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly] = scala
      .Option(impl.progressEvent())
      .map(value => zio.aws.cloudcontrol.model.ProgressEvent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.CreateResourceResponse
  ): zio.aws.cloudcontrol.model.CreateResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
