package zio.aws.cloudcontrol.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourceRequestStatusResponse(
    progressEvent: Optional[zio.aws.cloudcontrol.model.ProgressEvent] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequestStatusResponse = {
    import GetResourceRequestStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequestStatusResponse
      .builder()
      .optionallyWith(progressEvent.map(value => value.buildAwsValue()))(
        _.progressEvent
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudcontrol.model.GetResourceRequestStatusResponse.ReadOnly =
    zio.aws.cloudcontrol.model.GetResourceRequestStatusResponse
      .wrap(buildAwsValue())
}
object GetResourceRequestStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequestStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudcontrol.model.GetResourceRequestStatusResponse =
      zio.aws.cloudcontrol.model.GetResourceRequestStatusResponse(
        progressEvent.map(value => value.asEditable)
      )
    def progressEvent
        : Optional[zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly]
    def getProgressEvent: ZIO[
      Any,
      AwsError,
      zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly
    ] = AwsError.unwrapOptionField("progressEvent", progressEvent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequestStatusResponse
  ) extends zio.aws.cloudcontrol.model.GetResourceRequestStatusResponse.ReadOnly {
    override val progressEvent
        : Optional[zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressEvent())
        .map(value => zio.aws.cloudcontrol.model.ProgressEvent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequestStatusResponse
  ): zio.aws.cloudcontrol.model.GetResourceRequestStatusResponse.ReadOnly =
    new Wrapper(impl)
}
