package zio.aws.cloudcontrol.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudcontrol.model.primitives.{
  Identifier,
  Timestamp,
  RequestToken,
  TypeName,
  StatusMessage,
  Properties
}
import scala.jdk.CollectionConverters._
final case class ProgressEvent(
    typeName: Optional[TypeName] = Optional.Absent,
    identifier: Optional[Identifier] = Optional.Absent,
    requestToken: Optional[RequestToken] = Optional.Absent,
    operation: Optional[zio.aws.cloudcontrol.model.Operation] = Optional.Absent,
    operationStatus: Optional[zio.aws.cloudcontrol.model.OperationStatus] =
      Optional.Absent,
    eventTime: Optional[Timestamp] = Optional.Absent,
    resourceModel: Optional[Properties] = Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    errorCode: Optional[zio.aws.cloudcontrol.model.HandlerErrorCode] =
      Optional.Absent,
    retryAfter: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent = {
    import ProgressEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent
      .builder()
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        identifier.map(value => Identifier.unwrap(value): java.lang.String)
      )(_.identifier)
      .optionallyWith(
        requestToken.map(value => RequestToken.unwrap(value): java.lang.String)
      )(_.requestToken)
      .optionallyWith(operation.map(value => value.unwrap))(_.operation)
      .optionallyWith(operationStatus.map(value => value.unwrap))(
        _.operationStatus
      )
      .optionallyWith(eventTime.map(value => Timestamp.unwrap(value): Instant))(
        _.eventTime
      )
      .optionallyWith(
        resourceModel.map(value => Properties.unwrap(value): java.lang.String)
      )(_.resourceModel)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        retryAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.retryAfter)
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly =
    zio.aws.cloudcontrol.model.ProgressEvent.wrap(buildAwsValue())
}
object ProgressEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.ProgressEvent =
      zio.aws.cloudcontrol.model.ProgressEvent(
        typeName.map(value => value),
        identifier.map(value => value),
        requestToken.map(value => value),
        operation.map(value => value),
        operationStatus.map(value => value),
        eventTime.map(value => value),
        resourceModel.map(value => value),
        statusMessage.map(value => value),
        errorCode.map(value => value),
        retryAfter.map(value => value)
      )
    def typeName: Optional[TypeName]
    def identifier: Optional[Identifier]
    def requestToken: Optional[RequestToken]
    def operation: Optional[zio.aws.cloudcontrol.model.Operation]
    def operationStatus: Optional[zio.aws.cloudcontrol.model.OperationStatus]
    def eventTime: Optional[Timestamp]
    def resourceModel: Optional[Properties]
    def statusMessage: Optional[StatusMessage]
    def errorCode: Optional[zio.aws.cloudcontrol.model.HandlerErrorCode]
    def retryAfter: Optional[Timestamp]
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getIdentifier: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getRequestToken: ZIO[Any, AwsError, RequestToken] =
      AwsError.unwrapOptionField("requestToken", requestToken)
    def getOperation: ZIO[Any, AwsError, zio.aws.cloudcontrol.model.Operation] =
      AwsError.unwrapOptionField("operation", operation)
    def getOperationStatus
        : ZIO[Any, AwsError, zio.aws.cloudcontrol.model.OperationStatus] =
      AwsError.unwrapOptionField("operationStatus", operationStatus)
    def getEventTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventTime", eventTime)
    def getResourceModel: ZIO[Any, AwsError, Properties] =
      AwsError.unwrapOptionField("resourceModel", resourceModel)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.cloudcontrol.model.HandlerErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getRetryAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("retryAfter", retryAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent
  ) extends zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly {
    override val typeName: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.cloudcontrol.model.primitives.TypeName(value))
    override val identifier: Optional[Identifier] = zio.aws.core.internal
      .optionalFromNullable(impl.identifier())
      .map(value => zio.aws.cloudcontrol.model.primitives.Identifier(value))
    override val requestToken: Optional[RequestToken] = zio.aws.core.internal
      .optionalFromNullable(impl.requestToken())
      .map(value => zio.aws.cloudcontrol.model.primitives.RequestToken(value))
    override val operation: Optional[zio.aws.cloudcontrol.model.Operation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value => zio.aws.cloudcontrol.model.Operation.wrap(value))
    override val operationStatus
        : Optional[zio.aws.cloudcontrol.model.OperationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationStatus())
        .map(value => zio.aws.cloudcontrol.model.OperationStatus.wrap(value))
    override val eventTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.eventTime())
      .map(value => zio.aws.cloudcontrol.model.primitives.Timestamp(value))
    override val resourceModel: Optional[Properties] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceModel())
      .map(value => zio.aws.cloudcontrol.model.primitives.Properties(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.cloudcontrol.model.primitives.StatusMessage(value))
    override val errorCode
        : Optional[zio.aws.cloudcontrol.model.HandlerErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.cloudcontrol.model.HandlerErrorCode.wrap(value))
    override val retryAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.retryAfter())
      .map(value => zio.aws.cloudcontrol.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent
  ): zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly = new Wrapper(impl)
}
