package zio.aws.cloudcontrol.model
import zio.aws.cloudcontrol.model.primitives.{Properties, Identifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceDescription(
    identifier: Optional[Identifier] = Optional.Absent,
    properties: Optional[Properties] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription = {
    import ResourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription
      .builder()
      .optionallyWith(
        identifier.map(value => Identifier.unwrap(value): java.lang.String)
      )(_.identifier)
      .optionallyWith(
        properties.map(value => Properties.unwrap(value): java.lang.String)
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly =
    zio.aws.cloudcontrol.model.ResourceDescription.wrap(buildAwsValue())
}
object ResourceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.ResourceDescription =
      zio.aws.cloudcontrol.model.ResourceDescription(
        identifier.map(value => value),
        properties.map(value => value)
      )
    def identifier: Optional[Identifier]
    def properties: Optional[Properties]
    def getIdentifier: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getProperties: ZIO[Any, AwsError, Properties] =
      AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription
  ) extends zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly {
    override val identifier: Optional[Identifier] = zio.aws.core.internal
      .optionalFromNullable(impl.identifier())
      .map(value => zio.aws.cloudcontrol.model.primitives.Identifier(value))
    override val properties: Optional[Properties] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value => zio.aws.cloudcontrol.model.primitives.Properties(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription
  ): zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly = new Wrapper(impl)
}
