package zio.aws.cloudcontrol.model
import zio.aws.cloudcontrol.model.primitives.{
  TypeVersionId,
  RoleArn,
  Identifier,
  ClientToken,
  TypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteResourceRequest(
    typeName: TypeName,
    typeVersionId: Optional[TypeVersionId] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    identifier: Identifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceRequest = {
    import DeleteResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceRequest
      .builder()
      .typeName(TypeName.unwrap(typeName): java.lang.String)
      .optionallyWith(
        typeVersionId.map(value =>
          TypeVersionId.unwrap(value): java.lang.String
        )
      )(_.typeVersionId)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .identifier(Identifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.DeleteResourceRequest.ReadOnly =
    zio.aws.cloudcontrol.model.DeleteResourceRequest.wrap(buildAwsValue())
}
object DeleteResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.DeleteResourceRequest =
      zio.aws.cloudcontrol.model.DeleteResourceRequest(
        typeName,
        typeVersionId.map(value => value),
        roleArn.map(value => value),
        clientToken.map(value => value),
        identifier
      )
    def typeName: TypeName
    def typeVersionId: Optional[TypeVersionId]
    def roleArn: Optional[RoleArn]
    def clientToken: Optional[ClientToken]
    def identifier: Identifier
    def getTypeName: ZIO[Any, Nothing, TypeName] = ZIO.succeed(typeName)
    def getTypeVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("typeVersionId", typeVersionId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getIdentifier: ZIO[Any, Nothing, Identifier] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceRequest
  ) extends zio.aws.cloudcontrol.model.DeleteResourceRequest.ReadOnly {
    override val typeName: TypeName =
      zio.aws.cloudcontrol.model.primitives.TypeName(impl.typeName())
    override val typeVersionId: Optional[TypeVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.typeVersionId())
      .map(value => zio.aws.cloudcontrol.model.primitives.TypeVersionId(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.cloudcontrol.model.primitives.RoleArn(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.cloudcontrol.model.primitives.ClientToken(value))
    override val identifier: Identifier =
      zio.aws.cloudcontrol.model.primitives.Identifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceRequest
  ): zio.aws.cloudcontrol.model.DeleteResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
