package zio.aws.cloudcontrol.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceRequestStatusFilter(
    operations: Optional[Iterable[zio.aws.cloudcontrol.model.Operation]] =
      Optional.Absent,
    operationStatuses: Optional[
      Iterable[zio.aws.cloudcontrol.model.OperationStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.ResourceRequestStatusFilter = {
    import ResourceRequestStatusFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.ResourceRequestStatusFilter
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.operationsWithStrings)
      .optionallyWith(
        operationStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.operationStatusesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudcontrol.model.ResourceRequestStatusFilter.ReadOnly =
    zio.aws.cloudcontrol.model.ResourceRequestStatusFilter.wrap(buildAwsValue())
}
object ResourceRequestStatusFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.ResourceRequestStatusFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.ResourceRequestStatusFilter =
      zio.aws.cloudcontrol.model.ResourceRequestStatusFilter(
        operations.map(value => value),
        operationStatuses.map(value => value)
      )
    def operations: Optional[List[zio.aws.cloudcontrol.model.Operation]]
    def operationStatuses
        : Optional[List[zio.aws.cloudcontrol.model.OperationStatus]]
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.cloudcontrol.model.Operation]] =
      AwsError.unwrapOptionField("operations", operations)
    def getOperationStatuses
        : ZIO[Any, AwsError, List[zio.aws.cloudcontrol.model.OperationStatus]] =
      AwsError.unwrapOptionField("operationStatuses", operationStatuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ResourceRequestStatusFilter
  ) extends zio.aws.cloudcontrol.model.ResourceRequestStatusFilter.ReadOnly {
    override val operations
        : Optional[List[zio.aws.cloudcontrol.model.Operation]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudcontrol.model.Operation.wrap(item)
          }.toList
        )
    override val operationStatuses
        : Optional[List[zio.aws.cloudcontrol.model.OperationStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudcontrol.model.OperationStatus.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ResourceRequestStatusFilter
  ): zio.aws.cloudcontrol.model.ResourceRequestStatusFilter.ReadOnly =
    new Wrapper(impl)
}
