package zio.aws.cloudcontrol.model
import zio.aws.cloudcontrol.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListResourceRequestsResponse(
    resourceRequestStatusSummaries: Optional[
      Iterable[zio.aws.cloudcontrol.model.ProgressEvent]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsResponse = {
    import ListResourceRequestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsResponse
      .builder()
      .optionallyWith(
        resourceRequestStatusSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRequestStatusSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudcontrol.model.ListResourceRequestsResponse.ReadOnly =
    zio.aws.cloudcontrol.model.ListResourceRequestsResponse
      .wrap(buildAwsValue())
}
object ListResourceRequestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.ListResourceRequestsResponse =
      zio.aws.cloudcontrol.model.ListResourceRequestsResponse(
        resourceRequestStatusSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceRequestStatusSummaries
        : Optional[List[zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getResourceRequestStatusSummaries: ZIO[Any, AwsError, List[
      zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceRequestStatusSummaries",
      resourceRequestStatusSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsResponse
  ) extends zio.aws.cloudcontrol.model.ListResourceRequestsResponse.ReadOnly {
    override val resourceRequestStatusSummaries
        : Optional[List[zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRequestStatusSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudcontrol.model.ProgressEvent.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudcontrol.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsResponse
  ): zio.aws.cloudcontrol.model.ListResourceRequestsResponse.ReadOnly =
    new Wrapper(impl)
}
