package zio.aws.cloudcontrol.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudcontrol.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListResourceRequestsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    resourceRequestStatusFilter: Optional[
      zio.aws.cloudcontrol.model.ResourceRequestStatusFilter
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsRequest = {
    import ListResourceRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        resourceRequestStatusFilter.map(value => value.buildAwsValue())
      )(_.resourceRequestStatusFilter)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudcontrol.model.ListResourceRequestsRequest.ReadOnly =
    zio.aws.cloudcontrol.model.ListResourceRequestsRequest.wrap(buildAwsValue())
}
object ListResourceRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.ListResourceRequestsRequest =
      zio.aws.cloudcontrol.model.ListResourceRequestsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resourceRequestStatusFilter.map(value => value.asEditable)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def resourceRequestStatusFilter: Optional[
      zio.aws.cloudcontrol.model.ResourceRequestStatusFilter.ReadOnly
    ]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceRequestStatusFilter: ZIO[
      Any,
      AwsError,
      zio.aws.cloudcontrol.model.ResourceRequestStatusFilter.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourceRequestStatusFilter",
      resourceRequestStatusFilter
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsRequest
  ) extends zio.aws.cloudcontrol.model.ListResourceRequestsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cloudcontrol.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudcontrol.model.primitives.NextToken(value))
    override val resourceRequestStatusFilter: Optional[
      zio.aws.cloudcontrol.model.ResourceRequestStatusFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceRequestStatusFilter())
      .map(value =>
        zio.aws.cloudcontrol.model.ResourceRequestStatusFilter.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsRequest
  ): zio.aws.cloudcontrol.model.ListResourceRequestsRequest.ReadOnly =
    new Wrapper(impl)
}
