package zio.aws.cloudcontrol.model
import scala.jdk.CollectionConverters._
sealed trait HandlerErrorCode {
  def unwrap
      : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode
}
object HandlerErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode
  ): zio.aws.cloudcontrol.model.HandlerErrorCode = value match {
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.NOT_UPDATABLE =>
      val r = NotUpdatable
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.INVALID_REQUEST =>
      val r = InvalidRequest
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.ACCESS_DENIED =>
      val r = AccessDenied
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.INVALID_CREDENTIALS =>
      val r = InvalidCredentials
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.ALREADY_EXISTS =>
      val r = AlreadyExists
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.NOT_FOUND =>
      val r = NotFound
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.RESOURCE_CONFLICT =>
      val r = ResourceConflict
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.THROTTLING =>
      val r = Throttling
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.SERVICE_LIMIT_EXCEEDED =>
      val r = ServiceLimitExceeded
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.NOT_STABILIZED =>
      val r = NotStabilized
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.GENERAL_SERVICE_EXCEPTION =>
      val r = GeneralServiceException
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.SERVICE_INTERNAL_ERROR =>
      val r = ServiceInternalError
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.SERVICE_TIMEOUT =>
      val r = ServiceTimeout
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.NETWORK_FAILURE =>
      val r = NetworkFailure
      r
    case software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.INTERNAL_FAILURE =>
      val r = InternalFailure
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object NotUpdatable extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.NOT_UPDATABLE
  }
  case object InvalidRequest
      extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.INVALID_REQUEST
  }
  case object AccessDenied extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.ACCESS_DENIED
  }
  case object InvalidCredentials
      extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.INVALID_CREDENTIALS
  }
  case object AlreadyExists
      extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.ALREADY_EXISTS
  }
  case object NotFound extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.NOT_FOUND
  }
  case object ResourceConflict
      extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.RESOURCE_CONFLICT
  }
  case object Throttling extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.THROTTLING
  }
  case object ServiceLimitExceeded
      extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.SERVICE_LIMIT_EXCEEDED
  }
  case object NotStabilized
      extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.NOT_STABILIZED
  }
  case object GeneralServiceException
      extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.GENERAL_SERVICE_EXCEPTION
  }
  case object ServiceInternalError
      extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.SERVICE_INTERNAL_ERROR
  }
  case object ServiceTimeout
      extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.SERVICE_TIMEOUT
  }
  case object NetworkFailure
      extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.NETWORK_FAILURE
  }
  case object InternalFailure
      extends zio.aws.cloudcontrol.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode.INTERNAL_FAILURE
  }
}
