package zio.aws.cloudcontrol.model
import zio.aws.cloudcontrol.model.primitives.{
  TypeVersionId,
  RoleArn,
  ClientToken,
  TypeName,
  Properties
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateResourceRequest(
    typeName: TypeName,
    typeVersionId: Optional[TypeVersionId] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    desiredState: Properties
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.CreateResourceRequest = {
    import CreateResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.CreateResourceRequest
      .builder()
      .typeName(TypeName.unwrap(typeName): java.lang.String)
      .optionallyWith(
        typeVersionId.map(value =>
          TypeVersionId.unwrap(value): java.lang.String
        )
      )(_.typeVersionId)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .desiredState(Properties.unwrap(desiredState): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.CreateResourceRequest.ReadOnly =
    zio.aws.cloudcontrol.model.CreateResourceRequest.wrap(buildAwsValue())
}
object CreateResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.CreateResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.CreateResourceRequest =
      zio.aws.cloudcontrol.model.CreateResourceRequest(
        typeName,
        typeVersionId.map(value => value),
        roleArn.map(value => value),
        clientToken.map(value => value),
        desiredState
      )
    def typeName: TypeName
    def typeVersionId: Optional[TypeVersionId]
    def roleArn: Optional[RoleArn]
    def clientToken: Optional[ClientToken]
    def desiredState: Properties
    def getTypeName: ZIO[Any, Nothing, TypeName] = ZIO.succeed(typeName)
    def getTypeVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("typeVersionId", typeVersionId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDesiredState: ZIO[Any, Nothing, Properties] =
      ZIO.succeed(desiredState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.CreateResourceRequest
  ) extends zio.aws.cloudcontrol.model.CreateResourceRequest.ReadOnly {
    override val typeName: TypeName =
      zio.aws.cloudcontrol.model.primitives.TypeName(impl.typeName())
    override val typeVersionId: Optional[TypeVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.typeVersionId())
      .map(value => zio.aws.cloudcontrol.model.primitives.TypeVersionId(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.cloudcontrol.model.primitives.RoleArn(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.cloudcontrol.model.primitives.ClientToken(value))
    override val desiredState: Properties =
      zio.aws.cloudcontrol.model.primitives.Properties(impl.desiredState())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.CreateResourceRequest
  ): zio.aws.cloudcontrol.model.CreateResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
