package zio.aws.cloudcontrol.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateResourceResponse(
    progressEvent: Optional[zio.aws.cloudcontrol.model.ProgressEvent] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceResponse = {
    import UpdateResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceResponse
      .builder()
      .optionallyWith(progressEvent.map(value => value.buildAwsValue()))(
        _.progressEvent
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.UpdateResourceResponse.ReadOnly =
    zio.aws.cloudcontrol.model.UpdateResourceResponse.wrap(buildAwsValue())
}
object UpdateResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.UpdateResourceResponse =
      zio.aws.cloudcontrol.model
        .UpdateResourceResponse(progressEvent.map(value => value.asEditable))
    def progressEvent
        : Optional[zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly]
    def getProgressEvent: ZIO[
      Any,
      AwsError,
      zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly
    ] = AwsError.unwrapOptionField("progressEvent", progressEvent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceResponse
  ) extends zio.aws.cloudcontrol.model.UpdateResourceResponse.ReadOnly {
    override val progressEvent
        : Optional[zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressEvent())
        .map(value => zio.aws.cloudcontrol.model.ProgressEvent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceResponse
  ): zio.aws.cloudcontrol.model.UpdateResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
