package zio.aws.cloudcontrol
import zio.mock.{Proxy, Mock}
import zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly
import zio.aws.cloudcontrol.model.{
  CancelResourceRequestRequest,
  GetResourceRequestStatusRequest,
  DeleteResourceRequest,
  ListResourcesRequest,
  GetResourceRequest,
  CreateResourceRequest,
  ListResourceRequestsRequest,
  UpdateResourceRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.cloudcontrol.CloudControlAsyncClient
object CloudControlMock extends Mock[CloudControl] {
  object GetResource
      extends Effect[
        GetResourceRequest,
        AwsError,
        zio.aws.cloudcontrol.model.GetResourceResponse.ReadOnly
      ]
  object CancelResourceRequest
      extends Effect[
        CancelResourceRequestRequest,
        AwsError,
        zio.aws.cloudcontrol.model.CancelResourceRequestResponse.ReadOnly
      ]
  object CreateResource
      extends Effect[
        CreateResourceRequest,
        AwsError,
        zio.aws.cloudcontrol.model.CreateResourceResponse.ReadOnly
      ]
  object UpdateResource
      extends Effect[
        UpdateResourceRequest,
        AwsError,
        zio.aws.cloudcontrol.model.UpdateResourceResponse.ReadOnly
      ]
  object GetResourceRequestStatus
      extends Effect[
        GetResourceRequestStatusRequest,
        AwsError,
        zio.aws.cloudcontrol.model.GetResourceRequestStatusResponse.ReadOnly
      ]
  object ListResourceRequests
      extends Stream[ListResourceRequestsRequest, AwsError, ReadOnly]
  object ListResourceRequestsPaginated
      extends Effect[
        ListResourceRequestsRequest,
        AwsError,
        zio.aws.cloudcontrol.model.ListResourceRequestsResponse.ReadOnly
      ]
  object ListResources
      extends Effect[ListResourcesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.cloudcontrol.model.ListResourcesResponse.ReadOnly,
        zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly
      ]]
  object ListResourcesPaginated
      extends Effect[
        ListResourcesRequest,
        AwsError,
        zio.aws.cloudcontrol.model.ListResourcesResponse.ReadOnly
      ]
  object DeleteResource
      extends Effect[
        DeleteResourceRequest,
        AwsError,
        zio.aws.cloudcontrol.model.DeleteResourceResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CloudControl] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new CloudControl {
          val api: CloudControlAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : CloudControl = this
          def getResource(request: GetResourceRequest): IO[
            AwsError,
            zio.aws.cloudcontrol.model.GetResourceResponse.ReadOnly
          ] = proxy(GetResource, request)
          def cancelResourceRequest(request: CancelResourceRequestRequest): IO[
            AwsError,
            zio.aws.cloudcontrol.model.CancelResourceRequestResponse.ReadOnly
          ] = proxy(CancelResourceRequest, request)
          def createResource(request: CreateResourceRequest): IO[
            AwsError,
            zio.aws.cloudcontrol.model.CreateResourceResponse.ReadOnly
          ] = proxy(CreateResource, request)
          def updateResource(request: UpdateResourceRequest): IO[
            AwsError,
            zio.aws.cloudcontrol.model.UpdateResourceResponse.ReadOnly
          ] = proxy(UpdateResource, request)
          def getResourceRequestStatus(
              request: GetResourceRequestStatusRequest
          ): IO[
            AwsError,
            zio.aws.cloudcontrol.model.GetResourceRequestStatusResponse.ReadOnly
          ] = proxy(GetResourceRequestStatus, request)
          def listResourceRequests(
              request: ListResourceRequestsRequest
          ): ZStream[Any, AwsError, ReadOnly] =
            rts.unsafeRun(proxy(ListResourceRequests, request))
          def listResourceRequestsPaginated(
              request: ListResourceRequestsRequest
          ): IO[
            AwsError,
            zio.aws.cloudcontrol.model.ListResourceRequestsResponse.ReadOnly
          ] = proxy(ListResourceRequestsPaginated, request)
          def listResources(
              request: ListResourcesRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.cloudcontrol.model.ListResourcesResponse.ReadOnly,
            zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly
          ]] = proxy(ListResources, request)
          def listResourcesPaginated(request: ListResourcesRequest): IO[
            AwsError,
            zio.aws.cloudcontrol.model.ListResourcesResponse.ReadOnly
          ] = proxy(ListResourcesPaginated, request)
          def deleteResource(request: DeleteResourceRequest): IO[
            AwsError,
            zio.aws.cloudcontrol.model.DeleteResourceResponse.ReadOnly
          ] = proxy(DeleteResource, request)
        }
      }
    }
  }
}
