package zio.aws.cloudcontrol.model
import zio.aws.cloudcontrol.model.primitives.{HandlerNextToken, TypeName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListResourcesResponse(
    typeName: Option[TypeName] = None,
    resourceDescriptions: Option[
      Iterable[zio.aws.cloudcontrol.model.ResourceDescription]
    ] = None,
    nextToken: Option[HandlerNextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.ListResourcesResponse = {
    import ListResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.ListResourcesResponse
      .builder()
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        resourceDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceDescriptions)
      .optionallyWith(
        nextToken.map(value => HandlerNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.ListResourcesResponse.ReadOnly =
    zio.aws.cloudcontrol.model.ListResourcesResponse.wrap(buildAwsValue())
}
object ListResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.ListResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.ListResourcesResponse =
      zio.aws.cloudcontrol.model.ListResourcesResponse(
        typeName.map(value => value),
        resourceDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def typeName: Option[TypeName]
    def resourceDescriptions
        : Option[List[zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly]]
    def nextToken: Option[HandlerNextToken]
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getResourceDescriptions: ZIO[Any, AwsError, List[
      zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceDescriptions", resourceDescriptions)
    def getNextToken: ZIO[Any, AwsError, HandlerNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ListResourcesResponse
  ) extends zio.aws.cloudcontrol.model.ListResourcesResponse.ReadOnly {
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudcontrol.model.primitives.TypeName(value))
    override val resourceDescriptions: Option[
      List[zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly]
    ] = scala
      .Option(impl.resourceDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudcontrol.model.ResourceDescription.wrap(item)
        }.toList
      )
    override val nextToken: Option[HandlerNextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cloudcontrol.model.primitives.HandlerNextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ListResourcesResponse
  ): zio.aws.cloudcontrol.model.ListResourcesResponse.ReadOnly = new Wrapper(
    impl
  )
}
