package zio.aws.cloudcontrol.model
import zio.aws.cloudcontrol.model.primitives.RequestToken
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelResourceRequestRequest(requestToken: RequestToken) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestRequest = {
    import CancelResourceRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestRequest
      .builder()
      .requestToken(RequestToken.unwrap(requestToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudcontrol.model.CancelResourceRequestRequest.ReadOnly =
    zio.aws.cloudcontrol.model.CancelResourceRequestRequest
      .wrap(buildAwsValue())
}
object CancelResourceRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.CancelResourceRequestRequest =
      zio.aws.cloudcontrol.model.CancelResourceRequestRequest(requestToken)
    def requestToken: RequestToken
    def getRequestToken: ZIO[Any, Nothing, RequestToken] =
      ZIO.succeed(requestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestRequest
  ) extends zio.aws.cloudcontrol.model.CancelResourceRequestRequest.ReadOnly {
    override val requestToken: RequestToken =
      zio.aws.cloudcontrol.model.primitives.RequestToken(impl.requestToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestRequest
  ): zio.aws.cloudcontrol.model.CancelResourceRequestRequest.ReadOnly =
    new Wrapper(impl)
}
