package zio.aws.cloudcontrol.model
import zio.aws.cloudcontrol.model.primitives.{
  TypeVersionId,
  RoleArn,
  Identifier,
  PatchDocument,
  ClientToken,
  TypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateResourceRequest(
    typeName: TypeName,
    typeVersionId: Option[TypeVersionId] = None,
    roleArn: Option[RoleArn] = None,
    clientToken: Option[ClientToken] = None,
    identifier: Identifier,
    patchDocument: PatchDocument
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceRequest = {
    import UpdateResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceRequest
      .builder()
      .typeName(TypeName.unwrap(typeName): java.lang.String)
      .optionallyWith(
        typeVersionId.map(value =>
          TypeVersionId.unwrap(value): java.lang.String
        )
      )(_.typeVersionId)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .identifier(Identifier.unwrap(identifier): java.lang.String)
      .patchDocument(PatchDocument.unwrap(patchDocument): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.UpdateResourceRequest.ReadOnly =
    zio.aws.cloudcontrol.model.UpdateResourceRequest.wrap(buildAwsValue())
}
object UpdateResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.UpdateResourceRequest =
      zio.aws.cloudcontrol.model.UpdateResourceRequest(
        typeName,
        typeVersionId.map(value => value),
        roleArn.map(value => value),
        clientToken.map(value => value),
        identifier,
        patchDocument
      )
    def typeName: TypeName
    def typeVersionId: Option[TypeVersionId]
    def roleArn: Option[RoleArn]
    def clientToken: Option[ClientToken]
    def identifier: Identifier
    def patchDocument: PatchDocument
    def getTypeName: ZIO[Any, Nothing, TypeName] = ZIO.succeed(typeName)
    def getTypeVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("typeVersionId", typeVersionId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getIdentifier: ZIO[Any, Nothing, Identifier] = ZIO.succeed(identifier)
    def getPatchDocument: ZIO[Any, Nothing, PatchDocument] =
      ZIO.succeed(patchDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceRequest
  ) extends zio.aws.cloudcontrol.model.UpdateResourceRequest.ReadOnly {
    override val typeName: TypeName =
      zio.aws.cloudcontrol.model.primitives.TypeName(impl.typeName())
    override val typeVersionId: Option[TypeVersionId] = scala
      .Option(impl.typeVersionId())
      .map(value => zio.aws.cloudcontrol.model.primitives.TypeVersionId(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.cloudcontrol.model.primitives.RoleArn(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.cloudcontrol.model.primitives.ClientToken(value))
    override val identifier: Identifier =
      zio.aws.cloudcontrol.model.primitives.Identifier(impl.identifier())
    override val patchDocument: PatchDocument =
      zio.aws.cloudcontrol.model.primitives.PatchDocument(impl.patchDocument())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceRequest
  ): zio.aws.cloudcontrol.model.UpdateResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
