package zio.aws.cloudcontrol.model
import java.lang.Integer
import zio.aws.cloudcontrol.model.primitives.{
  TypeVersionId,
  RoleArn,
  HandlerNextToken,
  MaxResults,
  TypeName,
  Properties
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListResourcesRequest(
    typeName: TypeName,
    typeVersionId: Option[TypeVersionId] = None,
    roleArn: Option[RoleArn] = None,
    nextToken: Option[HandlerNextToken] = None,
    maxResults: Option[MaxResults] = None,
    resourceModel: Option[Properties] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.ListResourcesRequest = {
    import ListResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.ListResourcesRequest
      .builder()
      .typeName(TypeName.unwrap(typeName): java.lang.String)
      .optionallyWith(
        typeVersionId.map(value =>
          TypeVersionId.unwrap(value): java.lang.String
        )
      )(_.typeVersionId)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        nextToken.map(value => HandlerNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        resourceModel.map(value => Properties.unwrap(value): java.lang.String)
      )(_.resourceModel)
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.ListResourcesRequest.ReadOnly =
    zio.aws.cloudcontrol.model.ListResourcesRequest.wrap(buildAwsValue())
}
object ListResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.ListResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.ListResourcesRequest =
      zio.aws.cloudcontrol.model.ListResourcesRequest(
        typeName,
        typeVersionId.map(value => value),
        roleArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        resourceModel.map(value => value)
      )
    def typeName: TypeName
    def typeVersionId: Option[TypeVersionId]
    def roleArn: Option[RoleArn]
    def nextToken: Option[HandlerNextToken]
    def maxResults: Option[MaxResults]
    def resourceModel: Option[Properties]
    def getTypeName: ZIO[Any, Nothing, TypeName] = ZIO.succeed(typeName)
    def getTypeVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("typeVersionId", typeVersionId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getNextToken: ZIO[Any, AwsError, HandlerNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResourceModel: ZIO[Any, AwsError, Properties] =
      AwsError.unwrapOptionField("resourceModel", resourceModel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ListResourcesRequest
  ) extends zio.aws.cloudcontrol.model.ListResourcesRequest.ReadOnly {
    override val typeName: TypeName =
      zio.aws.cloudcontrol.model.primitives.TypeName(impl.typeName())
    override val typeVersionId: Option[TypeVersionId] = scala
      .Option(impl.typeVersionId())
      .map(value => zio.aws.cloudcontrol.model.primitives.TypeVersionId(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.cloudcontrol.model.primitives.RoleArn(value))
    override val nextToken: Option[HandlerNextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cloudcontrol.model.primitives.HandlerNextToken(value)
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.cloudcontrol.model.primitives.MaxResults(value))
    override val resourceModel: Option[Properties] = scala
      .Option(impl.resourceModel())
      .map(value => zio.aws.cloudcontrol.model.primitives.Properties(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.ListResourcesRequest
  ): zio.aws.cloudcontrol.model.ListResourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
