package zio.aws.cloudcontrol.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteResourceResponse(
    progressEvent: Option[zio.aws.cloudcontrol.model.ProgressEvent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceResponse = {
    import DeleteResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceResponse
      .builder()
      .optionallyWith(progressEvent.map(value => value.buildAwsValue()))(
        _.progressEvent
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.DeleteResourceResponse.ReadOnly =
    zio.aws.cloudcontrol.model.DeleteResourceResponse.wrap(buildAwsValue())
}
object DeleteResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.DeleteResourceResponse =
      zio.aws.cloudcontrol.model
        .DeleteResourceResponse(progressEvent.map(value => value.asEditable))
    def progressEvent: Option[zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly]
    def getProgressEvent: ZIO[
      Any,
      AwsError,
      zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly
    ] = AwsError.unwrapOptionField("progressEvent", progressEvent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceResponse
  ) extends zio.aws.cloudcontrol.model.DeleteResourceResponse.ReadOnly {
    override val progressEvent
        : Option[zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly] = scala
      .Option(impl.progressEvent())
      .map(value => zio.aws.cloudcontrol.model.ProgressEvent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceResponse
  ): zio.aws.cloudcontrol.model.DeleteResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
