package zio.aws.cloudcontrol.model
import zio.aws.cloudcontrol.model.primitives.TypeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetResourceResponse(
    typeName: Option[TypeName] = None,
    resourceDescription: Option[
      zio.aws.cloudcontrol.model.ResourceDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.GetResourceResponse = {
    import GetResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.GetResourceResponse
      .builder()
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(resourceDescription.map(value => value.buildAwsValue()))(
        _.resourceDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.GetResourceResponse.ReadOnly =
    zio.aws.cloudcontrol.model.GetResourceResponse.wrap(buildAwsValue())
}
object GetResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.GetResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.GetResourceResponse =
      zio.aws.cloudcontrol.model.GetResourceResponse(
        typeName.map(value => value),
        resourceDescription.map(value => value.asEditable)
      )
    def typeName: Option[TypeName]
    def resourceDescription
        : Option[zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly]
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getResourceDescription: ZIO[
      Any,
      AwsError,
      zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly
    ] = AwsError.unwrapOptionField("resourceDescription", resourceDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.GetResourceResponse
  ) extends zio.aws.cloudcontrol.model.GetResourceResponse.ReadOnly {
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudcontrol.model.primitives.TypeName(value))
    override val resourceDescription
        : Option[zio.aws.cloudcontrol.model.ResourceDescription.ReadOnly] =
      scala
        .Option(impl.resourceDescription())
        .map(value =>
          zio.aws.cloudcontrol.model.ResourceDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.GetResourceResponse
  ): zio.aws.cloudcontrol.model.GetResourceResponse.ReadOnly = new Wrapper(impl)
}
