package zio.aws.cloud9.model
import zio.aws.cloud9.model.primitives.EnvironmentArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceARN: EnvironmentArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(EnvironmentArn.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.cloud9.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.ListTagsForResourceRequest =
      zio.aws.cloud9.model.ListTagsForResourceRequest(resourceARN)
    def resourceARN: EnvironmentArn
    def getResourceARN: ZIO[Any, Nothing, EnvironmentArn] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.ListTagsForResourceRequest
  ) extends zio.aws.cloud9.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: EnvironmentArn =
      zio.aws.cloud9.model.primitives.EnvironmentArn(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.ListTagsForResourceRequest
  ): zio.aws.cloud9.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
