package zio.aws.cloud9.model
import zio.aws.cloud9.model.primitives.{UserArn, EnvironmentId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentMembershipRequest(
    environmentId: EnvironmentId,
    userArn: UserArn,
    permissions: zio.aws.cloud9.model.MemberPermissions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipRequest = {
    import UpdateEnvironmentMembershipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipRequest
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .permissions(permissions.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.cloud9.model.UpdateEnvironmentMembershipRequest.ReadOnly =
    zio.aws.cloud9.model.UpdateEnvironmentMembershipRequest
      .wrap(buildAwsValue())
}
object UpdateEnvironmentMembershipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.UpdateEnvironmentMembershipRequest =
      zio.aws.cloud9.model
        .UpdateEnvironmentMembershipRequest(environmentId, userArn, permissions)
    def environmentId: EnvironmentId
    def userArn: UserArn
    def permissions: zio.aws.cloud9.model.MemberPermissions
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
    def getPermissions
        : ZIO[Any, Nothing, zio.aws.cloud9.model.MemberPermissions] =
      ZIO.succeed(permissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipRequest
  ) extends zio.aws.cloud9.model.UpdateEnvironmentMembershipRequest.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.cloud9.model.primitives.EnvironmentId(impl.environmentId())
    override val userArn: UserArn =
      zio.aws.cloud9.model.primitives.UserArn(impl.userArn())
    override val permissions: zio.aws.cloud9.model.MemberPermissions =
      zio.aws.cloud9.model.MemberPermissions.wrap(impl.permissions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipRequest
  ): zio.aws.cloud9.model.UpdateEnvironmentMembershipRequest.ReadOnly =
    new Wrapper(impl)
}
