package zio.aws.cloud9.model
import zio.aws.cloud9.model.primitives.{UserArn, EnvironmentId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEnvironmentMembershipRequest(
    environmentId: EnvironmentId,
    userArn: UserArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentMembershipRequest = {
    import DeleteEnvironmentMembershipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentMembershipRequest
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloud9.model.DeleteEnvironmentMembershipRequest.ReadOnly =
    zio.aws.cloud9.model.DeleteEnvironmentMembershipRequest
      .wrap(buildAwsValue())
}
object DeleteEnvironmentMembershipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentMembershipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.DeleteEnvironmentMembershipRequest =
      zio.aws.cloud9.model
        .DeleteEnvironmentMembershipRequest(environmentId, userArn)
    def environmentId: EnvironmentId
    def userArn: UserArn
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentMembershipRequest
  ) extends zio.aws.cloud9.model.DeleteEnvironmentMembershipRequest.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.cloud9.model.primitives.EnvironmentId(impl.environmentId())
    override val userArn: UserArn =
      zio.aws.cloud9.model.primitives.UserArn(impl.userArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentMembershipRequest
  ): zio.aws.cloud9.model.DeleteEnvironmentMembershipRequest.ReadOnly =
    new Wrapper(impl)
}
