package zio.aws.cloud9.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentMembershipResponse(
    membership: Optional[zio.aws.cloud9.model.EnvironmentMember] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipResponse = {
    import UpdateEnvironmentMembershipResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipResponse
      .builder()
      .optionallyWith(membership.map(value => value.buildAwsValue()))(
        _.membership
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloud9.model.UpdateEnvironmentMembershipResponse.ReadOnly =
    zio.aws.cloud9.model.UpdateEnvironmentMembershipResponse
      .wrap(buildAwsValue())
}
object UpdateEnvironmentMembershipResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.UpdateEnvironmentMembershipResponse =
      zio.aws.cloud9.model.UpdateEnvironmentMembershipResponse(
        membership.map(value => value.asEditable)
      )
    def membership: Optional[zio.aws.cloud9.model.EnvironmentMember.ReadOnly]
    def getMembership
        : ZIO[Any, AwsError, zio.aws.cloud9.model.EnvironmentMember.ReadOnly] =
      AwsError.unwrapOptionField("membership", membership)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipResponse
  ) extends zio.aws.cloud9.model.UpdateEnvironmentMembershipResponse.ReadOnly {
    override val membership
        : Optional[zio.aws.cloud9.model.EnvironmentMember.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.membership())
        .map(value => zio.aws.cloud9.model.EnvironmentMember.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipResponse
  ): zio.aws.cloud9.model.UpdateEnvironmentMembershipResponse.ReadOnly =
    new Wrapper(impl)
}
