package zio.aws.cloud9.model
import zio.aws.cloud9.model.primitives.{
  EnvironmentDescription,
  EnvironmentName,
  EnvironmentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentRequest(
    environmentId: EnvironmentId,
    name: Optional[EnvironmentName] = Optional.Absent,
    description: Optional[EnvironmentDescription] = Optional.Absent,
    managedCredentialsAction: Optional[
      zio.aws.cloud9.model.ManagedCredentialsAction
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentRequest = {
    import UpdateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentRequest
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .optionallyWith(
        name.map(value => EnvironmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          EnvironmentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(managedCredentialsAction.map(value => value.unwrap))(
        _.managedCredentialsAction
      )
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.UpdateEnvironmentRequest.ReadOnly =
    zio.aws.cloud9.model.UpdateEnvironmentRequest.wrap(buildAwsValue())
}
object UpdateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.UpdateEnvironmentRequest =
      zio.aws.cloud9.model.UpdateEnvironmentRequest(
        environmentId,
        name.map(value => value),
        description.map(value => value),
        managedCredentialsAction.map(value => value)
      )
    def environmentId: EnvironmentId
    def name: Optional[EnvironmentName]
    def description: Optional[EnvironmentDescription]
    def managedCredentialsAction
        : Optional[zio.aws.cloud9.model.ManagedCredentialsAction]
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, EnvironmentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getManagedCredentialsAction
        : ZIO[Any, AwsError, zio.aws.cloud9.model.ManagedCredentialsAction] =
      AwsError.unwrapOptionField(
        "managedCredentialsAction",
        managedCredentialsAction
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentRequest
  ) extends zio.aws.cloud9.model.UpdateEnvironmentRequest.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.cloud9.model.primitives.EnvironmentId(impl.environmentId())
    override val name: Optional[EnvironmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.cloud9.model.primitives.EnvironmentName(value))
    override val description: Optional[EnvironmentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.cloud9.model.primitives.EnvironmentDescription(value)
        )
    override val managedCredentialsAction
        : Optional[zio.aws.cloud9.model.ManagedCredentialsAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedCredentialsAction())
        .map(value => zio.aws.cloud9.model.ManagedCredentialsAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentRequest
  ): zio.aws.cloud9.model.UpdateEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
