package zio.aws.cloud9.model
import scala.jdk.CollectionConverters._
sealed trait EnvironmentStatus {
  def unwrap: software.amazon.awssdk.services.cloud9.model.EnvironmentStatus
}
object EnvironmentStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloud9.model.EnvironmentStatus
  ): zio.aws.cloud9.model.EnvironmentStatus = value match {
    case software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.ERROR =>
      val r = error
      r
    case software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.CREATING =>
      val r = creating
      r
    case software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.CONNECTING =>
      val r = connecting
      r
    case software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.READY =>
      val r = ready
      r
    case software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.STOPPING =>
      val r = stopping
      r
    case software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.STOPPED =>
      val r = stopped
      r
    case software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.DELETING =>
      val r = deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloud9.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.EnvironmentStatus =
      software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object error extends zio.aws.cloud9.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.EnvironmentStatus =
      software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.ERROR
  }
  case object creating extends zio.aws.cloud9.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.EnvironmentStatus =
      software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.CREATING
  }
  case object connecting extends zio.aws.cloud9.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.EnvironmentStatus =
      software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.CONNECTING
  }
  case object ready extends zio.aws.cloud9.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.EnvironmentStatus =
      software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.READY
  }
  case object stopping extends zio.aws.cloud9.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.EnvironmentStatus =
      software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.STOPPING
  }
  case object stopped extends zio.aws.cloud9.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.EnvironmentStatus =
      software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.STOPPED
  }
  case object deleting extends zio.aws.cloud9.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.EnvironmentStatus =
      software.amazon.awssdk.services.cloud9.model.EnvironmentStatus.DELETING
  }
}
