package zio.aws.cloud9.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentMembershipResponse(
    membership: zio.aws.cloud9.model.EnvironmentMember
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.CreateEnvironmentMembershipResponse = {
    import CreateEnvironmentMembershipResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.CreateEnvironmentMembershipResponse
      .builder()
      .membership(membership.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloud9.model.CreateEnvironmentMembershipResponse.ReadOnly =
    zio.aws.cloud9.model.CreateEnvironmentMembershipResponse
      .wrap(buildAwsValue())
}
object CreateEnvironmentMembershipResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.CreateEnvironmentMembershipResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.CreateEnvironmentMembershipResponse =
      zio.aws.cloud9.model
        .CreateEnvironmentMembershipResponse(membership.asEditable)
    def membership: zio.aws.cloud9.model.EnvironmentMember.ReadOnly
    def getMembership
        : ZIO[Any, Nothing, zio.aws.cloud9.model.EnvironmentMember.ReadOnly] =
      ZIO.succeed(membership)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.CreateEnvironmentMembershipResponse
  ) extends zio.aws.cloud9.model.CreateEnvironmentMembershipResponse.ReadOnly {
    override val membership: zio.aws.cloud9.model.EnvironmentMember.ReadOnly =
      zio.aws.cloud9.model.EnvironmentMember.wrap(impl.membership())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.CreateEnvironmentMembershipResponse
  ): zio.aws.cloud9.model.CreateEnvironmentMembershipResponse.ReadOnly =
    new Wrapper(impl)
}
