package zio.aws.cloud9.model
import zio.aws.cloud9.model.primitives.EnvironmentId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentEc2Response(
    environmentId: Optional[EnvironmentId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Response = {
    import CreateEnvironmentEc2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Response
      .builder()
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.CreateEnvironmentEc2Response.ReadOnly =
    zio.aws.cloud9.model.CreateEnvironmentEc2Response.wrap(buildAwsValue())
}
object CreateEnvironmentEc2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.CreateEnvironmentEc2Response =
      zio.aws.cloud9.model
        .CreateEnvironmentEc2Response(environmentId.map(value => value))
    def environmentId: Optional[EnvironmentId]
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Response
  ) extends zio.aws.cloud9.model.CreateEnvironmentEc2Response.ReadOnly {
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.cloud9.model.primitives.EnvironmentId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Response
  ): zio.aws.cloud9.model.CreateEnvironmentEc2Response.ReadOnly = new Wrapper(
    impl
  )
}
