package zio.aws.cloud9.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionType {
  def unwrap: software.amazon.awssdk.services.cloud9.model.ConnectionType
}
object ConnectionType {
  def wrap(
      value: software.amazon.awssdk.services.cloud9.model.ConnectionType
  ): zio.aws.cloud9.model.ConnectionType = value match {
    case software.amazon.awssdk.services.cloud9.model.ConnectionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloud9.model.ConnectionType.CONNECT_SSH =>
      val r = CONNECT_SSH
      r
    case software.amazon.awssdk.services.cloud9.model.ConnectionType.CONNECT_SSM =>
      val r = CONNECT_SSM
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloud9.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ConnectionType =
      software.amazon.awssdk.services.cloud9.model.ConnectionType.UNKNOWN_TO_SDK_VERSION
  }
  case object CONNECT_SSH extends zio.aws.cloud9.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ConnectionType =
      software.amazon.awssdk.services.cloud9.model.ConnectionType.CONNECT_SSH
  }
  case object CONNECT_SSM extends zio.aws.cloud9.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ConnectionType =
      software.amazon.awssdk.services.cloud9.model.ConnectionType.CONNECT_SSM
  }
}
