package zio.aws.cloud9.model
import scala.jdk.CollectionConverters._
sealed trait Permissions {
  def unwrap: software.amazon.awssdk.services.cloud9.model.Permissions
}
object Permissions {
  def wrap(
      value: software.amazon.awssdk.services.cloud9.model.Permissions
  ): zio.aws.cloud9.model.Permissions = value match {
    case software.amazon.awssdk.services.cloud9.model.Permissions.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloud9.model.Permissions.OWNER =>
      val r = owner
      r
    case software.amazon.awssdk.services.cloud9.model.Permissions.READ_WRITE =>
      val r = `read-write`
      r
    case software.amazon.awssdk.services.cloud9.model.Permissions.READ_ONLY =>
      val r = `read-only`
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloud9.model.Permissions {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.Permissions =
      software.amazon.awssdk.services.cloud9.model.Permissions.UNKNOWN_TO_SDK_VERSION
  }
  case object owner extends zio.aws.cloud9.model.Permissions {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.Permissions =
      software.amazon.awssdk.services.cloud9.model.Permissions.OWNER
  }
  case object `read-write` extends zio.aws.cloud9.model.Permissions {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.Permissions =
      software.amazon.awssdk.services.cloud9.model.Permissions.READ_WRITE
  }
  case object `read-only` extends zio.aws.cloud9.model.Permissions {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.Permissions =
      software.amazon.awssdk.services.cloud9.model.Permissions.READ_ONLY
  }
}
