package zio.aws.cloud9.model
import zio.aws.cloud9.model.primitives.{
  EnvironmentDescription,
  EnvironmentName,
  EnvironmentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Environment(
    id: Optional[EnvironmentId] = Optional.Absent,
    name: Optional[EnvironmentName] = Optional.Absent,
    description: Optional[EnvironmentDescription] = Optional.Absent,
    `type`: zio.aws.cloud9.model.EnvironmentType,
    connectionType: Optional[zio.aws.cloud9.model.ConnectionType] =
      Optional.Absent,
    arn: String,
    ownerArn: String,
    lifecycle: Optional[zio.aws.cloud9.model.EnvironmentLifecycle] =
      Optional.Absent,
    managedCredentialsStatus: Optional[
      zio.aws.cloud9.model.ManagedCredentialsStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.Environment = {
    import Environment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.Environment
      .builder()
      .optionallyWith(
        id.map(value => EnvironmentId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => EnvironmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          EnvironmentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .`type`(`type`.unwrap)
      .optionallyWith(connectionType.map(value => value.unwrap))(
        _.connectionType
      )
      .arn(arn: java.lang.String)
      .ownerArn(ownerArn: java.lang.String)
      .optionallyWith(lifecycle.map(value => value.buildAwsValue()))(
        _.lifecycle
      )
      .optionallyWith(managedCredentialsStatus.map(value => value.unwrap))(
        _.managedCredentialsStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.Environment.ReadOnly =
    zio.aws.cloud9.model.Environment.wrap(buildAwsValue())
}
object Environment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.Environment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.Environment =
      zio.aws.cloud9.model.Environment(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        `type`,
        connectionType.map(value => value),
        arn,
        ownerArn,
        lifecycle.map(value => value.asEditable),
        managedCredentialsStatus.map(value => value)
      )
    def id: Optional[EnvironmentId]
    def name: Optional[EnvironmentName]
    def description: Optional[EnvironmentDescription]
    def `type`: zio.aws.cloud9.model.EnvironmentType
    def connectionType: Optional[zio.aws.cloud9.model.ConnectionType]
    def arn: String
    def ownerArn: String
    def lifecycle: Optional[zio.aws.cloud9.model.EnvironmentLifecycle.ReadOnly]
    def managedCredentialsStatus
        : Optional[zio.aws.cloud9.model.ManagedCredentialsStatus]
    def getId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, EnvironmentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, Nothing, zio.aws.cloud9.model.EnvironmentType] =
      ZIO.succeed(`type`)
    def getConnectionType
        : ZIO[Any, AwsError, zio.aws.cloud9.model.ConnectionType] =
      AwsError.unwrapOptionField("connectionType", connectionType)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getOwnerArn: ZIO[Any, Nothing, String] = ZIO.succeed(ownerArn)
    def getLifecycle: ZIO[
      Any,
      AwsError,
      zio.aws.cloud9.model.EnvironmentLifecycle.ReadOnly
    ] = AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getManagedCredentialsStatus
        : ZIO[Any, AwsError, zio.aws.cloud9.model.ManagedCredentialsStatus] =
      AwsError.unwrapOptionField(
        "managedCredentialsStatus",
        managedCredentialsStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.Environment
  ) extends zio.aws.cloud9.model.Environment.ReadOnly {
    override val id: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.cloud9.model.primitives.EnvironmentId(value))
    override val name: Optional[EnvironmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.cloud9.model.primitives.EnvironmentName(value))
    override val description: Optional[EnvironmentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.cloud9.model.primitives.EnvironmentDescription(value)
        )
    override val `type`: zio.aws.cloud9.model.EnvironmentType =
      zio.aws.cloud9.model.EnvironmentType.wrap(impl.`type`())
    override val connectionType: Optional[zio.aws.cloud9.model.ConnectionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionType())
        .map(value => zio.aws.cloud9.model.ConnectionType.wrap(value))
    override val arn: String = impl.arn(): String
    override val ownerArn: String = impl.ownerArn(): String
    override val lifecycle
        : Optional[zio.aws.cloud9.model.EnvironmentLifecycle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.cloud9.model.EnvironmentLifecycle.wrap(value))
    override val managedCredentialsStatus
        : Optional[zio.aws.cloud9.model.ManagedCredentialsStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedCredentialsStatus())
        .map(value => zio.aws.cloud9.model.ManagedCredentialsStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.Environment
  ): zio.aws.cloud9.model.Environment.ReadOnly = new Wrapper(impl)
}
