package zio.aws.cloud9.model
import scala.jdk.CollectionConverters._
sealed trait EnvironmentType {
  def unwrap: software.amazon.awssdk.services.cloud9.model.EnvironmentType
}
object EnvironmentType {
  def wrap(
      value: software.amazon.awssdk.services.cloud9.model.EnvironmentType
  ): zio.aws.cloud9.model.EnvironmentType = value match {
    case software.amazon.awssdk.services.cloud9.model.EnvironmentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloud9.model.EnvironmentType.SSH =>
      val r = ssh
      r
    case software.amazon.awssdk.services.cloud9.model.EnvironmentType.EC2 =>
      val r = ec2
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloud9.model.EnvironmentType {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.EnvironmentType =
      software.amazon.awssdk.services.cloud9.model.EnvironmentType.UNKNOWN_TO_SDK_VERSION
  }
  case object ssh extends zio.aws.cloud9.model.EnvironmentType {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.EnvironmentType =
      software.amazon.awssdk.services.cloud9.model.EnvironmentType.SSH
  }
  case object ec2 extends zio.aws.cloud9.model.EnvironmentType {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.EnvironmentType =
      software.amazon.awssdk.services.cloud9.model.EnvironmentType.EC2
  }
}
