package zio.aws.cloud9.model
import zio.aws.cloud9.model.primitives.EnvironmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEnvironmentRequest(environmentId: EnvironmentId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentRequest = {
    import DeleteEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentRequest
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.DeleteEnvironmentRequest.ReadOnly =
    zio.aws.cloud9.model.DeleteEnvironmentRequest.wrap(buildAwsValue())
}
object DeleteEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.DeleteEnvironmentRequest =
      zio.aws.cloud9.model.DeleteEnvironmentRequest(environmentId)
    def environmentId: EnvironmentId
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentRequest
  ) extends zio.aws.cloud9.model.DeleteEnvironmentRequest.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.cloud9.model.primitives.EnvironmentId(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentRequest
  ): zio.aws.cloud9.model.DeleteEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
