package zio.aws.cloud9.model
import zio.aws.cloud9.model.primitives.EnvironmentId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEnvironmentsResponse(
    nextToken: Optional[String] = Optional.Absent,
    environmentIds: Optional[Iterable[EnvironmentId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse = {
    import ListEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        environmentIds.map(value =>
          value.map { item =>
            EnvironmentId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.environmentIds)
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.ListEnvironmentsResponse.ReadOnly =
    zio.aws.cloud9.model.ListEnvironmentsResponse.wrap(buildAwsValue())
}
object ListEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.ListEnvironmentsResponse =
      zio.aws.cloud9.model.ListEnvironmentsResponse(
        nextToken.map(value => value),
        environmentIds.map(value => value)
      )
    def nextToken: Optional[String]
    def environmentIds: Optional[List[EnvironmentId]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getEnvironmentIds: ZIO[Any, AwsError, List[EnvironmentId]] =
      AwsError.unwrapOptionField("environmentIds", environmentIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse
  ) extends zio.aws.cloud9.model.ListEnvironmentsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val environmentIds: Optional[List[EnvironmentId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloud9.model.primitives.EnvironmentId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse
  ): zio.aws.cloud9.model.ListEnvironmentsResponse.ReadOnly = new Wrapper(impl)
}
