package zio.aws.cloud9.model
import zio.aws.cloud9.model.primitives.EnvironmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeEnvironmentsRequest(
    environmentIds: Iterable[EnvironmentId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsRequest = {
    import DescribeEnvironmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsRequest
      .builder()
      .environmentIds(environmentIds.map { item =>
        EnvironmentId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.DescribeEnvironmentsRequest.ReadOnly =
    zio.aws.cloud9.model.DescribeEnvironmentsRequest.wrap(buildAwsValue())
}
object DescribeEnvironmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.DescribeEnvironmentsRequest =
      zio.aws.cloud9.model.DescribeEnvironmentsRequest(environmentIds)
    def environmentIds: List[EnvironmentId]
    def getEnvironmentIds: ZIO[Any, Nothing, List[EnvironmentId]] =
      ZIO.succeed(environmentIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsRequest
  ) extends zio.aws.cloud9.model.DescribeEnvironmentsRequest.ReadOnly {
    override val environmentIds: List[EnvironmentId] = impl
      .environmentIds()
      .asScala
      .map { item =>
        zio.aws.cloud9.model.primitives.EnvironmentId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsRequest
  ): zio.aws.cloud9.model.DescribeEnvironmentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
