package zio.aws.cloud9.model
import zio.aws.cloud9.model.primitives.EnvironmentArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceARN: EnvironmentArn,
    tags: Iterable[zio.aws.cloud9.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.TagResourceRequest
      .builder()
      .resourceARN(EnvironmentArn.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.TagResourceRequest.ReadOnly =
    zio.aws.cloud9.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.TagResourceRequest =
      zio.aws.cloud9.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: EnvironmentArn
    def tags: List[zio.aws.cloud9.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, EnvironmentArn] =
      ZIO.succeed(resourceARN)
    def getTags: ZIO[Any, Nothing, List[zio.aws.cloud9.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.TagResourceRequest
  ) extends zio.aws.cloud9.model.TagResourceRequest.ReadOnly {
    override val resourceARN: EnvironmentArn =
      zio.aws.cloud9.model.primitives.EnvironmentArn(impl.resourceARN())
    override val tags: List[zio.aws.cloud9.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.cloud9.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.TagResourceRequest
  ): zio.aws.cloud9.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
