package zio.aws.cloud9
import zio.aws.cloud9.model.DeleteEnvironmentResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.cloud9.model.{
  ListEnvironmentsRequest,
  DescribeEnvironmentMembershipsRequest,
  CreateEnvironmentEc2Request,
  UpdateEnvironmentRequest,
  ListTagsForResourceRequest,
  DescribeEnvironmentsRequest,
  DeleteEnvironmentMembershipRequest,
  DescribeEnvironmentStatusRequest,
  UntagResourceRequest,
  CreateEnvironmentMembershipRequest,
  DeleteEnvironmentRequest,
  TagResourceRequest,
  UpdateEnvironmentMembershipRequest
}
import software.amazon.awssdk.services.cloud9.Cloud9AsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
object Cloud9Mock extends Mock[Cloud9] {
  object DeleteEnvironment
      extends Effect[DeleteEnvironmentRequest, AwsError, ReadOnly]
  object DescribeEnvironmentMemberships
      extends Effect[
        DescribeEnvironmentMembershipsRequest,
        AwsError,
        zio.aws.cloud9.model.DescribeEnvironmentMembershipsResponse.ReadOnly
      ]
  object DeleteEnvironmentMembership
      extends Effect[
        DeleteEnvironmentMembershipRequest,
        AwsError,
        zio.aws.cloud9.model.DeleteEnvironmentMembershipResponse.ReadOnly
      ]
  object UpdateEnvironmentMembership
      extends Effect[
        UpdateEnvironmentMembershipRequest,
        AwsError,
        zio.aws.cloud9.model.UpdateEnvironmentMembershipResponse.ReadOnly
      ]
  object ListEnvironments
      extends Effect[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.cloud9.model.ListEnvironmentsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.cloud9.model.UntagResourceResponse.ReadOnly
      ]
  object DescribeEnvironments
      extends Effect[
        DescribeEnvironmentsRequest,
        AwsError,
        zio.aws.cloud9.model.DescribeEnvironmentsResponse.ReadOnly
      ]
  object CreateEnvironmentEC2
      extends Effect[
        CreateEnvironmentEc2Request,
        AwsError,
        zio.aws.cloud9.model.CreateEnvironmentEc2Response.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.cloud9.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.cloud9.model.TagResourceResponse.ReadOnly
      ]
  object UpdateEnvironment
      extends Effect[
        UpdateEnvironmentRequest,
        AwsError,
        zio.aws.cloud9.model.UpdateEnvironmentResponse.ReadOnly
      ]
  object CreateEnvironmentMembership
      extends Effect[
        CreateEnvironmentMembershipRequest,
        AwsError,
        zio.aws.cloud9.model.CreateEnvironmentMembershipResponse.ReadOnly
      ]
  object DescribeEnvironmentStatus
      extends Effect[
        DescribeEnvironmentStatusRequest,
        AwsError,
        zio.aws.cloud9.model.DescribeEnvironmentStatusResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Cloud9] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Cloud9 {
          val api: Cloud9AsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Cloud9 = this
          def deleteEnvironment(
              request: DeleteEnvironmentRequest
          ): IO[AwsError, ReadOnly] = proxy(DeleteEnvironment, request)
          def describeEnvironmentMemberships(
              request: DescribeEnvironmentMembershipsRequest
          ): IO[
            AwsError,
            zio.aws.cloud9.model.DescribeEnvironmentMembershipsResponse.ReadOnly
          ] = proxy(DescribeEnvironmentMemberships, request)
          def deleteEnvironmentMembership(
              request: DeleteEnvironmentMembershipRequest
          ): IO[
            AwsError,
            zio.aws.cloud9.model.DeleteEnvironmentMembershipResponse.ReadOnly
          ] = proxy(DeleteEnvironmentMembership, request)
          def updateEnvironmentMembership(
              request: UpdateEnvironmentMembershipRequest
          ): IO[
            AwsError,
            zio.aws.cloud9.model.UpdateEnvironmentMembershipResponse.ReadOnly
          ] = proxy(UpdateEnvironmentMembership, request)
          def listEnvironments(request: ListEnvironmentsRequest): IO[
            AwsError,
            zio.aws.cloud9.model.ListEnvironmentsResponse.ReadOnly
          ] = proxy(ListEnvironments, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.cloud9.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def describeEnvironments(request: DescribeEnvironmentsRequest): IO[
            AwsError,
            zio.aws.cloud9.model.DescribeEnvironmentsResponse.ReadOnly
          ] = proxy(DescribeEnvironments, request)
          def createEnvironmentEC2(request: CreateEnvironmentEc2Request): IO[
            AwsError,
            zio.aws.cloud9.model.CreateEnvironmentEc2Response.ReadOnly
          ] = proxy(CreateEnvironmentEC2, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.cloud9.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.cloud9.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def updateEnvironment(request: UpdateEnvironmentRequest): IO[
            AwsError,
            zio.aws.cloud9.model.UpdateEnvironmentResponse.ReadOnly
          ] = proxy(UpdateEnvironment, request)
          def createEnvironmentMembership(
              request: CreateEnvironmentMembershipRequest
          ): IO[
            AwsError,
            zio.aws.cloud9.model.CreateEnvironmentMembershipResponse.ReadOnly
          ] = proxy(CreateEnvironmentMembership, request)
          def describeEnvironmentStatus(
              request: DescribeEnvironmentStatusRequest
          ): IO[
            AwsError,
            zio.aws.cloud9.model.DescribeEnvironmentStatusResponse.ReadOnly
          ] = proxy(DescribeEnvironmentStatus, request)
        }
      }
    }
  }
}
