package zio.aws.cloud9.model
import scala.jdk.CollectionConverters._
sealed trait ManagedCredentialsStatus {
  def unwrap
      : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus
}
object ManagedCredentialsStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus
  ): zio.aws.cloud9.model.ManagedCredentialsStatus = value match {
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.ENABLED_ON_CREATE =>
      val r = ENABLED_ON_CREATE
      r
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.ENABLED_BY_OWNER =>
      val r = ENABLED_BY_OWNER
      r
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.DISABLED_BY_DEFAULT =>
      val r = DISABLED_BY_DEFAULT
      r
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.DISABLED_BY_OWNER =>
      val r = DISABLED_BY_OWNER
      r
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.DISABLED_BY_COLLABORATOR =>
      val r = DISABLED_BY_COLLABORATOR
      r
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.PENDING_REMOVAL_BY_COLLABORATOR =>
      val r = PENDING_REMOVAL_BY_COLLABORATOR
      r
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.PENDING_START_REMOVAL_BY_COLLABORATOR =>
      val r = PENDING_START_REMOVAL_BY_COLLABORATOR
      r
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.PENDING_REMOVAL_BY_OWNER =>
      val r = PENDING_REMOVAL_BY_OWNER
      r
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.PENDING_START_REMOVAL_BY_OWNER =>
      val r = PENDING_START_REMOVAL_BY_OWNER
      r
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.FAILED_REMOVAL_BY_COLLABORATOR =>
      val r = FAILED_REMOVAL_BY_COLLABORATOR
      r
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.FAILED_REMOVAL_BY_OWNER =>
      val r = FAILED_REMOVAL_BY_OWNER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloud9.model.ManagedCredentialsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED_ON_CREATE
      extends zio.aws.cloud9.model.ManagedCredentialsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.ENABLED_ON_CREATE
  }
  case object ENABLED_BY_OWNER
      extends zio.aws.cloud9.model.ManagedCredentialsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.ENABLED_BY_OWNER
  }
  case object DISABLED_BY_DEFAULT
      extends zio.aws.cloud9.model.ManagedCredentialsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.DISABLED_BY_DEFAULT
  }
  case object DISABLED_BY_OWNER
      extends zio.aws.cloud9.model.ManagedCredentialsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.DISABLED_BY_OWNER
  }
  case object DISABLED_BY_COLLABORATOR
      extends zio.aws.cloud9.model.ManagedCredentialsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.DISABLED_BY_COLLABORATOR
  }
  case object PENDING_REMOVAL_BY_COLLABORATOR
      extends zio.aws.cloud9.model.ManagedCredentialsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.PENDING_REMOVAL_BY_COLLABORATOR
  }
  case object PENDING_START_REMOVAL_BY_COLLABORATOR
      extends zio.aws.cloud9.model.ManagedCredentialsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.PENDING_START_REMOVAL_BY_COLLABORATOR
  }
  case object PENDING_REMOVAL_BY_OWNER
      extends zio.aws.cloud9.model.ManagedCredentialsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.PENDING_REMOVAL_BY_OWNER
  }
  case object PENDING_START_REMOVAL_BY_OWNER
      extends zio.aws.cloud9.model.ManagedCredentialsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.PENDING_START_REMOVAL_BY_OWNER
  }
  case object FAILED_REMOVAL_BY_COLLABORATOR
      extends zio.aws.cloud9.model.ManagedCredentialsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.FAILED_REMOVAL_BY_COLLABORATOR
  }
  case object FAILED_REMOVAL_BY_OWNER
      extends zio.aws.cloud9.model.ManagedCredentialsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus.FAILED_REMOVAL_BY_OWNER
  }
}
