package zio.aws.cloud9.model
import zio.aws.cloud9.model.primitives.EnvironmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeEnvironmentStatusRequest(
    environmentId: EnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusRequest = {
    import DescribeEnvironmentStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusRequest
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloud9.model.DescribeEnvironmentStatusRequest.ReadOnly =
    zio.aws.cloud9.model.DescribeEnvironmentStatusRequest.wrap(buildAwsValue())
}
object DescribeEnvironmentStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.DescribeEnvironmentStatusRequest =
      zio.aws.cloud9.model.DescribeEnvironmentStatusRequest(environmentId)
    def environmentId: EnvironmentId
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusRequest
  ) extends zio.aws.cloud9.model.DescribeEnvironmentStatusRequest.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.cloud9.model.primitives.EnvironmentId(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusRequest
  ): zio.aws.cloud9.model.DescribeEnvironmentStatusRequest.ReadOnly =
    new Wrapper(impl)
}
