package zio.aws.cloud9.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeEnvironmentStatusResponse(
    status: zio.aws.cloud9.model.EnvironmentStatus,
    message: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusResponse = {
    import DescribeEnvironmentStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusResponse
      .builder()
      .status(status.unwrap)
      .message(message: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloud9.model.DescribeEnvironmentStatusResponse.ReadOnly =
    zio.aws.cloud9.model.DescribeEnvironmentStatusResponse.wrap(buildAwsValue())
}
object DescribeEnvironmentStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.DescribeEnvironmentStatusResponse =
      zio.aws.cloud9.model.DescribeEnvironmentStatusResponse(status, message)
    def status: zio.aws.cloud9.model.EnvironmentStatus
    def message: String
    def getStatus: ZIO[Any, Nothing, zio.aws.cloud9.model.EnvironmentStatus] =
      ZIO.succeed(status)
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusResponse
  ) extends zio.aws.cloud9.model.DescribeEnvironmentStatusResponse.ReadOnly {
    override val status: zio.aws.cloud9.model.EnvironmentStatus =
      zio.aws.cloud9.model.EnvironmentStatus.wrap(impl.status())
    override val message: String = impl.message(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusResponse
  ): zio.aws.cloud9.model.DescribeEnvironmentStatusResponse.ReadOnly =
    new Wrapper(impl)
}
