package zio.aws.cloud9.model
import scala.jdk.CollectionConverters._
sealed trait MemberPermissions {
  def unwrap: software.amazon.awssdk.services.cloud9.model.MemberPermissions
}
object MemberPermissions {
  def wrap(
      value: software.amazon.awssdk.services.cloud9.model.MemberPermissions
  ): zio.aws.cloud9.model.MemberPermissions = value match {
    case software.amazon.awssdk.services.cloud9.model.MemberPermissions.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloud9.model.MemberPermissions.READ_WRITE =>
      val r = `read-write`
      r
    case software.amazon.awssdk.services.cloud9.model.MemberPermissions.READ_ONLY =>
      val r = `read-only`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloud9.model.MemberPermissions {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.MemberPermissions =
      software.amazon.awssdk.services.cloud9.model.MemberPermissions.UNKNOWN_TO_SDK_VERSION
  }
  case object `read-write` extends zio.aws.cloud9.model.MemberPermissions {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.MemberPermissions =
      software.amazon.awssdk.services.cloud9.model.MemberPermissions.READ_WRITE
  }
  case object `read-only` extends zio.aws.cloud9.model.MemberPermissions {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.MemberPermissions =
      software.amazon.awssdk.services.cloud9.model.MemberPermissions.READ_ONLY
  }
}
