package zio.aws.cloud9
import zio.aws.cloud9.model.DeleteEnvironmentResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.cloud9.model.{
  ListEnvironmentsRequest,
  DescribeEnvironmentMembershipsRequest,
  CreateEnvironmentEc2Request,
  UpdateEnvironmentRequest,
  ListTagsForResourceRequest,
  DescribeEnvironmentsRequest,
  DeleteEnvironmentMembershipRequest,
  DescribeEnvironmentStatusRequest,
  UntagResourceRequest,
  CreateEnvironmentMembershipRequest,
  DeleteEnvironmentRequest,
  TagResourceRequest,
  UpdateEnvironmentMembershipRequest
}
import software.amazon.awssdk.services.cloud9.{
  Cloud9AsyncClientBuilder,
  Cloud9AsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.cloud9.model.{
  DescribeEnvironmentStatusResponse,
  UpdateEnvironmentMembershipResponse,
  DescribeEnvironmentsResponse,
  DescribeEnvironmentMembershipsResponse,
  UpdateEnvironmentResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateEnvironmentEc2Response,
  DeleteEnvironmentMembershipResponse,
  TagResourceResponse,
  CreateEnvironmentMembershipResponse,
  ListEnvironmentsResponse,
  DeleteEnvironmentResponse
}
import scala.jdk.CollectionConverters._
trait Cloud9 extends AspectSupport[Cloud9] {
  val api: Cloud9AsyncClient
  def deleteEnvironment(
      request: DeleteEnvironmentRequest
  ): IO[AwsError, ReadOnly]
  def describeEnvironmentMemberships(
      request: DescribeEnvironmentMembershipsRequest
  ): IO[
    AwsError,
    zio.aws.cloud9.model.DescribeEnvironmentMembershipsResponse.ReadOnly
  ]
  def deleteEnvironmentMembership(
      request: DeleteEnvironmentMembershipRequest
  ): IO[
    AwsError,
    zio.aws.cloud9.model.DeleteEnvironmentMembershipResponse.ReadOnly
  ]
  def updateEnvironmentMembership(
      request: UpdateEnvironmentMembershipRequest
  ): IO[
    AwsError,
    zio.aws.cloud9.model.UpdateEnvironmentMembershipResponse.ReadOnly
  ]
  def listEnvironments(
      request: ListEnvironmentsRequest
  ): IO[AwsError, zio.aws.cloud9.model.ListEnvironmentsResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.cloud9.model.UntagResourceResponse.ReadOnly]
  def describeEnvironments(
      request: DescribeEnvironmentsRequest
  ): IO[AwsError, zio.aws.cloud9.model.DescribeEnvironmentsResponse.ReadOnly]
  def createEnvironmentEC2(
      request: CreateEnvironmentEc2Request
  ): IO[AwsError, zio.aws.cloud9.model.CreateEnvironmentEc2Response.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.cloud9.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.cloud9.model.TagResourceResponse.ReadOnly]
  def updateEnvironment(
      request: UpdateEnvironmentRequest
  ): IO[AwsError, zio.aws.cloud9.model.UpdateEnvironmentResponse.ReadOnly]
  def createEnvironmentMembership(
      request: CreateEnvironmentMembershipRequest
  ): IO[
    AwsError,
    zio.aws.cloud9.model.CreateEnvironmentMembershipResponse.ReadOnly
  ]
  def describeEnvironmentStatus(request: DescribeEnvironmentStatusRequest): IO[
    AwsError,
    zio.aws.cloud9.model.DescribeEnvironmentStatusResponse.ReadOnly
  ]
}
object Cloud9 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Cloud9] = customized(
    identity
  )
  def customized(
      customization: Cloud9AsyncClientBuilder => Cloud9AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Cloud9] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: Cloud9AsyncClientBuilder => Cloud9AsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Cloud9] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = Cloud9AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[Cloud9AsyncClient, Cloud9AsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[Cloud9AsyncClient, Cloud9AsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new Cloud9Impl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class Cloud9Impl[R](
      override val api: Cloud9AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Cloud9
      with AwsServiceBase[R] {
    override val serviceName: String = "Cloud9"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): Cloud9Impl[R1] = new Cloud9Impl(api, newAspect, r)
    def deleteEnvironment(
        request: DeleteEnvironmentRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentRequest,
      DeleteEnvironmentResponse
    ]("deleteEnvironment", api.deleteEnvironment)(request.buildAwsValue())
      .map(zio.aws.cloud9.model.DeleteEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def describeEnvironmentMemberships(
        request: DescribeEnvironmentMembershipsRequest
    ): IO[
      AwsError,
      zio.aws.cloud9.model.DescribeEnvironmentMembershipsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest,
      DescribeEnvironmentMembershipsResponse
    ]("describeEnvironmentMemberships", api.describeEnvironmentMemberships)(
      request.buildAwsValue()
    ).map(zio.aws.cloud9.model.DescribeEnvironmentMembershipsResponse.wrap)
      .provideEnvironment(r)
    def deleteEnvironmentMembership(
        request: DeleteEnvironmentMembershipRequest
    ): IO[
      AwsError,
      zio.aws.cloud9.model.DeleteEnvironmentMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentMembershipRequest,
      DeleteEnvironmentMembershipResponse
    ]("deleteEnvironmentMembership", api.deleteEnvironmentMembership)(
      request.buildAwsValue()
    ).map(zio.aws.cloud9.model.DeleteEnvironmentMembershipResponse.wrap)
      .provideEnvironment(r)
    def updateEnvironmentMembership(
        request: UpdateEnvironmentMembershipRequest
    ): IO[
      AwsError,
      zio.aws.cloud9.model.UpdateEnvironmentMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipRequest,
      UpdateEnvironmentMembershipResponse
    ]("updateEnvironmentMembership", api.updateEnvironmentMembership)(
      request.buildAwsValue()
    ).map(zio.aws.cloud9.model.UpdateEnvironmentMembershipResponse.wrap)
      .provideEnvironment(r)
    def listEnvironments(
        request: ListEnvironmentsRequest
    ): IO[AwsError, zio.aws.cloud9.model.ListEnvironmentsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest,
        ListEnvironmentsResponse
      ]("listEnvironments", api.listEnvironments)(request.buildAwsValue())
        .map(zio.aws.cloud9.model.ListEnvironmentsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.cloud9.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloud9.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.cloud9.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeEnvironments(request: DescribeEnvironmentsRequest): IO[
      AwsError,
      zio.aws.cloud9.model.DescribeEnvironmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsRequest,
      DescribeEnvironmentsResponse
    ]("describeEnvironments", api.describeEnvironments)(request.buildAwsValue())
      .map(zio.aws.cloud9.model.DescribeEnvironmentsResponse.wrap)
      .provideEnvironment(r)
    def createEnvironmentEC2(request: CreateEnvironmentEc2Request): IO[
      AwsError,
      zio.aws.cloud9.model.CreateEnvironmentEc2Response.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Request,
      CreateEnvironmentEc2Response
    ]("createEnvironmentEC2", api.createEnvironmentEC2)(request.buildAwsValue())
      .map(zio.aws.cloud9.model.CreateEnvironmentEc2Response.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.cloud9.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloud9.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.cloud9.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.cloud9.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloud9.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.cloud9.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateEnvironment(
        request: UpdateEnvironmentRequest
    ): IO[AwsError, zio.aws.cloud9.model.UpdateEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentRequest,
        UpdateEnvironmentResponse
      ]("updateEnvironment", api.updateEnvironment)(request.buildAwsValue())
        .map(zio.aws.cloud9.model.UpdateEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def createEnvironmentMembership(
        request: CreateEnvironmentMembershipRequest
    ): IO[
      AwsError,
      zio.aws.cloud9.model.CreateEnvironmentMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloud9.model.CreateEnvironmentMembershipRequest,
      CreateEnvironmentMembershipResponse
    ]("createEnvironmentMembership", api.createEnvironmentMembership)(
      request.buildAwsValue()
    ).map(zio.aws.cloud9.model.CreateEnvironmentMembershipResponse.wrap)
      .provideEnvironment(r)
    def describeEnvironmentStatus(
        request: DescribeEnvironmentStatusRequest
    ): IO[
      AwsError,
      zio.aws.cloud9.model.DescribeEnvironmentStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusRequest,
      DescribeEnvironmentStatusResponse
    ]("describeEnvironmentStatus", api.describeEnvironmentStatus)(
      request.buildAwsValue()
    ).map(zio.aws.cloud9.model.DescribeEnvironmentStatusResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteEnvironment(
      request: DeleteEnvironmentRequest
  ): ZIO[zio.aws.cloud9.Cloud9, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteEnvironment(request))
  def describeEnvironmentMemberships(
      request: DescribeEnvironmentMembershipsRequest
  ): ZIO[
    zio.aws.cloud9.Cloud9,
    AwsError,
    zio.aws.cloud9.model.DescribeEnvironmentMembershipsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEnvironmentMemberships(request))
  def deleteEnvironmentMembership(
      request: DeleteEnvironmentMembershipRequest
  ): ZIO[
    zio.aws.cloud9.Cloud9,
    AwsError,
    zio.aws.cloud9.model.DeleteEnvironmentMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEnvironmentMembership(request))
  def updateEnvironmentMembership(
      request: UpdateEnvironmentMembershipRequest
  ): ZIO[
    zio.aws.cloud9.Cloud9,
    AwsError,
    zio.aws.cloud9.model.UpdateEnvironmentMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnvironmentMembership(request))
  def listEnvironments(request: ListEnvironmentsRequest): ZIO[
    zio.aws.cloud9.Cloud9,
    AwsError,
    zio.aws.cloud9.model.ListEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironments(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.cloud9.Cloud9,
    AwsError,
    zio.aws.cloud9.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeEnvironments(request: DescribeEnvironmentsRequest): ZIO[
    zio.aws.cloud9.Cloud9,
    AwsError,
    zio.aws.cloud9.model.DescribeEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEnvironments(request))
  def createEnvironmentEC2(request: CreateEnvironmentEc2Request): ZIO[
    zio.aws.cloud9.Cloud9,
    AwsError,
    zio.aws.cloud9.model.CreateEnvironmentEc2Response.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEnvironmentEC2(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.cloud9.Cloud9,
    AwsError,
    zio.aws.cloud9.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.cloud9.Cloud9,
    AwsError,
    zio.aws.cloud9.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateEnvironment(request: UpdateEnvironmentRequest): ZIO[
    zio.aws.cloud9.Cloud9,
    AwsError,
    zio.aws.cloud9.model.UpdateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnvironment(request))
  def createEnvironmentMembership(
      request: CreateEnvironmentMembershipRequest
  ): ZIO[
    zio.aws.cloud9.Cloud9,
    AwsError,
    zio.aws.cloud9.model.CreateEnvironmentMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEnvironmentMembership(request))
  def describeEnvironmentStatus(request: DescribeEnvironmentStatusRequest): ZIO[
    zio.aws.cloud9.Cloud9,
    AwsError,
    zio.aws.cloud9.model.DescribeEnvironmentStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEnvironmentStatus(request))
}
