package zio.aws.cloud9.model
import zio.aws.cloud9.model.primitives.{Timestamp, EnvironmentId, UserArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EnvironmentMember(
    permissions: zio.aws.cloud9.model.Permissions,
    userId: String,
    userArn: UserArn,
    environmentId: EnvironmentId,
    lastAccess: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.EnvironmentMember = {
    import EnvironmentMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.EnvironmentMember
      .builder()
      .permissions(permissions.unwrap)
      .userId(userId: java.lang.String)
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .optionallyWith(
        lastAccess.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastAccess)
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.EnvironmentMember.ReadOnly =
    zio.aws.cloud9.model.EnvironmentMember.wrap(buildAwsValue())
}
object EnvironmentMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.EnvironmentMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.EnvironmentMember =
      zio.aws.cloud9.model.EnvironmentMember(
        permissions,
        userId,
        userArn,
        environmentId,
        lastAccess.map(value => value)
      )
    def permissions: zio.aws.cloud9.model.Permissions
    def userId: String
    def userArn: UserArn
    def environmentId: EnvironmentId
    def lastAccess: Option[Timestamp]
    def getPermissions: ZIO[Any, Nothing, zio.aws.cloud9.model.Permissions] =
      ZIO.succeed(permissions)
    def getUserId: ZIO[Any, Nothing, String] = ZIO.succeed(userId)
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getLastAccess: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastAccess", lastAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.EnvironmentMember
  ) extends zio.aws.cloud9.model.EnvironmentMember.ReadOnly {
    override val permissions: zio.aws.cloud9.model.Permissions =
      zio.aws.cloud9.model.Permissions.wrap(impl.permissions())
    override val userId: String = impl.userId(): String
    override val userArn: UserArn =
      zio.aws.cloud9.model.primitives.UserArn(impl.userArn())
    override val environmentId: EnvironmentId =
      zio.aws.cloud9.model.primitives.EnvironmentId(impl.environmentId())
    override val lastAccess: Option[Timestamp] = scala
      .Option(impl.lastAccess())
      .map(value => zio.aws.cloud9.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.EnvironmentMember
  ): zio.aws.cloud9.model.EnvironmentMember.ReadOnly = new Wrapper(impl)
}
