package zio.aws.cloud9.model
import java.lang.Integer
import zio.aws.cloud9.model.primitives.{
  SubnetId,
  UserArn,
  EnvironmentDescription,
  ClientRequestToken,
  InstanceType,
  EnvironmentName,
  AutomaticStopTimeMinutes,
  NullableBoolean,
  ImageId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentEc2Request(
    name: EnvironmentName,
    description: Option[EnvironmentDescription] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    instanceType: InstanceType,
    subnetId: Option[SubnetId] = None,
    imageId: Option[ImageId] = None,
    automaticStopTimeMinutes: Option[AutomaticStopTimeMinutes] = None,
    ownerArn: Option[UserArn] = None,
    tags: Option[Iterable[zio.aws.cloud9.model.Tag]] = None,
    connectionType: Option[zio.aws.cloud9.model.ConnectionType] = None,
    dryRun: Option[NullableBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Request = {
    import CreateEnvironmentEc2Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Request
      .builder()
      .name(EnvironmentName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EnvironmentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .instanceType(InstanceType.unwrap(instanceType): java.lang.String)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        automaticStopTimeMinutes.map(value =>
          AutomaticStopTimeMinutes.unwrap(value): Integer
        )
      )(_.automaticStopTimeMinutes)
      .optionallyWith(
        ownerArn.map(value => UserArn.unwrap(value): java.lang.String)
      )(_.ownerArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(connectionType.map(value => value.unwrap))(
        _.connectionType
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.CreateEnvironmentEc2Request.ReadOnly =
    zio.aws.cloud9.model.CreateEnvironmentEc2Request.wrap(buildAwsValue())
}
object CreateEnvironmentEc2Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.CreateEnvironmentEc2Request =
      zio.aws.cloud9.model.CreateEnvironmentEc2Request(
        name,
        description.map(value => value),
        clientRequestToken.map(value => value),
        instanceType,
        subnetId.map(value => value),
        imageId.map(value => value),
        automaticStopTimeMinutes.map(value => value),
        ownerArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        connectionType.map(value => value),
        dryRun.map(value => value)
      )
    def name: EnvironmentName
    def description: Option[EnvironmentDescription]
    def clientRequestToken: Option[ClientRequestToken]
    def instanceType: InstanceType
    def subnetId: Option[SubnetId]
    def imageId: Option[ImageId]
    def automaticStopTimeMinutes: Option[AutomaticStopTimeMinutes]
    def ownerArn: Option[UserArn]
    def tags: Option[List[zio.aws.cloud9.model.Tag.ReadOnly]]
    def connectionType: Option[zio.aws.cloud9.model.ConnectionType]
    def dryRun: Option[NullableBoolean]
    def getName: ZIO[Any, Nothing, EnvironmentName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, EnvironmentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getInstanceType: ZIO[Any, Nothing, InstanceType] =
      ZIO.succeed(instanceType)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getAutomaticStopTimeMinutes
        : ZIO[Any, AwsError, AutomaticStopTimeMinutes] = AwsError
      .unwrapOptionField("automaticStopTimeMinutes", automaticStopTimeMinutes)
    def getOwnerArn: ZIO[Any, AwsError, UserArn] =
      AwsError.unwrapOptionField("ownerArn", ownerArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.cloud9.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConnectionType
        : ZIO[Any, AwsError, zio.aws.cloud9.model.ConnectionType] =
      AwsError.unwrapOptionField("connectionType", connectionType)
    def getDryRun: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Request
  ) extends zio.aws.cloud9.model.CreateEnvironmentEc2Request.ReadOnly {
    override val name: EnvironmentName =
      zio.aws.cloud9.model.primitives.EnvironmentName(impl.name())
    override val description: Option[EnvironmentDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.cloud9.model.primitives.EnvironmentDescription(value)
      )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.cloud9.model.primitives.ClientRequestToken(value))
    override val instanceType: InstanceType =
      zio.aws.cloud9.model.primitives.InstanceType(impl.instanceType())
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.cloud9.model.primitives.SubnetId(value))
    override val imageId: Option[ImageId] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.cloud9.model.primitives.ImageId(value))
    override val automaticStopTimeMinutes: Option[AutomaticStopTimeMinutes] =
      scala
        .Option(impl.automaticStopTimeMinutes())
        .map(value =>
          zio.aws.cloud9.model.primitives.AutomaticStopTimeMinutes(value)
        )
    override val ownerArn: Option[UserArn] = scala
      .Option(impl.ownerArn())
      .map(value => zio.aws.cloud9.model.primitives.UserArn(value))
    override val tags: Option[List[zio.aws.cloud9.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloud9.model.Tag.wrap(item)
        }.toList
      )
    override val connectionType: Option[zio.aws.cloud9.model.ConnectionType] =
      scala
        .Option(impl.connectionType())
        .map(value => zio.aws.cloud9.model.ConnectionType.wrap(value))
    override val dryRun: Option[NullableBoolean] =
      scala.Option(impl.dryRun()).map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Request
  ): zio.aws.cloud9.model.CreateEnvironmentEc2Request.ReadOnly = new Wrapper(
    impl
  )
}
