package zio.aws.cloud9.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEnvironmentsResponse(
    environments: Option[Iterable[zio.aws.cloud9.model.Environment]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsResponse = {
    import DescribeEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsResponse
      .builder()
      .optionallyWith(
        environments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environments)
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.DescribeEnvironmentsResponse.ReadOnly =
    zio.aws.cloud9.model.DescribeEnvironmentsResponse.wrap(buildAwsValue())
}
object DescribeEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.DescribeEnvironmentsResponse =
      zio.aws.cloud9.model.DescribeEnvironmentsResponse(
        environments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def environments: Option[List[zio.aws.cloud9.model.Environment.ReadOnly]]
    def getEnvironments
        : ZIO[Any, AwsError, List[zio.aws.cloud9.model.Environment.ReadOnly]] =
      AwsError.unwrapOptionField("environments", environments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsResponse
  ) extends zio.aws.cloud9.model.DescribeEnvironmentsResponse.ReadOnly {
    override val environments
        : Option[List[zio.aws.cloud9.model.Environment.ReadOnly]] = scala
      .Option(impl.environments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloud9.model.Environment.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsResponse
  ): zio.aws.cloud9.model.DescribeEnvironmentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
