package zio.aws.cloud9.model
import java.lang.Integer
import zio.aws.cloud9.model.primitives.MaxResults
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEnvironmentsRequest(
    nextToken: Option[String] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest = {
    import ListEnvironmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.ListEnvironmentsRequest.ReadOnly =
    zio.aws.cloud9.model.ListEnvironmentsRequest.wrap(buildAwsValue())
}
object ListEnvironmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.ListEnvironmentsRequest =
      zio.aws.cloud9.model.ListEnvironmentsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[String]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest
  ) extends zio.aws.cloud9.model.ListEnvironmentsRequest.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.cloud9.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest
  ): zio.aws.cloud9.model.ListEnvironmentsRequest.ReadOnly = new Wrapper(impl)
}
