package zio.aws.cloud9.model
import zio.aws.cloud9.model.primitives.{TagKey, EnvironmentArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceARN: EnvironmentArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.UntagResourceRequest
      .builder()
      .resourceARN(EnvironmentArn.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloud9.model.UntagResourceRequest.ReadOnly =
    zio.aws.cloud9.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloud9.model.UntagResourceRequest =
      zio.aws.cloud9.model.UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: EnvironmentArn
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, EnvironmentArn] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.UntagResourceRequest
  ) extends zio.aws.cloud9.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: EnvironmentArn =
      zio.aws.cloud9.model.primitives.EnvironmentArn(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.cloud9.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.UntagResourceRequest
  ): zio.aws.cloud9.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
