package zio.aws.cloud9.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEnvironmentMembershipsResponse(
    memberships: Option[Iterable[zio.aws.cloud9.model.EnvironmentMember]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse = {
    import DescribeEnvironmentMembershipsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse
      .builder()
      .optionallyWith(
        memberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.memberships)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloud9.model.DescribeEnvironmentMembershipsResponse.ReadOnly =
    zio.aws.cloud9.model.DescribeEnvironmentMembershipsResponse
      .wrap(buildAwsValue())
}
object DescribeEnvironmentMembershipsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloud9.model.DescribeEnvironmentMembershipsResponse =
      zio.aws.cloud9.model.DescribeEnvironmentMembershipsResponse(
        memberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def memberships
        : Option[List[zio.aws.cloud9.model.EnvironmentMember.ReadOnly]]
    def nextToken: Option[String]
    def getMemberships: ZIO[Any, AwsError, List[
      zio.aws.cloud9.model.EnvironmentMember.ReadOnly
    ]] = AwsError.unwrapOptionField("memberships", memberships)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse
  ) extends zio.aws.cloud9.model.DescribeEnvironmentMembershipsResponse.ReadOnly {
    override val memberships
        : Option[List[zio.aws.cloud9.model.EnvironmentMember.ReadOnly]] = scala
      .Option(impl.memberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloud9.model.EnvironmentMember.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse
  ): zio.aws.cloud9.model.DescribeEnvironmentMembershipsResponse.ReadOnly =
    new Wrapper(impl)
}
