package zio.aws.cloud9.model
import scala.jdk.CollectionConverters._
sealed trait ManagedCredentialsAction {
  def unwrap
      : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsAction
}
object ManagedCredentialsAction {
  def wrap(
      value: software.amazon.awssdk.services.cloud9.model.ManagedCredentialsAction
  ): zio.aws.cloud9.model.ManagedCredentialsAction = value match {
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsAction.ENABLE =>
      val r = ENABLE
      r
    case software.amazon.awssdk.services.cloud9.model.ManagedCredentialsAction.DISABLE =>
      val r = DISABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloud9.model.ManagedCredentialsAction {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsAction =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsAction.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLE extends zio.aws.cloud9.model.ManagedCredentialsAction {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsAction =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsAction.ENABLE
  }
  case object DISABLE extends zio.aws.cloud9.model.ManagedCredentialsAction {
    override def unwrap
        : software.amazon.awssdk.services.cloud9.model.ManagedCredentialsAction =
      software.amazon.awssdk.services.cloud9.model.ManagedCredentialsAction.DISABLE
  }
}
